/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal.migration;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import com.xpn.xwiki.store.migration.hibernate.HibernateDataMigration;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.solr.client.solrj.SolrServerException;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.search.solr.internal.api.SolrInstance;

@Component
@Named(value="R141015000XWIKI20371XWIKI21208")
@Singleton
public class R141015000XWIKI20371XWIKI21208DataMigration
implements HibernateDataMigration {
    public static final String HINT = "R141015000XWIKI20371XWIKI21208";
    @Inject
    private SolrInstance solrInstance;
    @Inject
    private Execution execution;

    private XWikiContext getXWikiContext() {
        ExecutionContext context = this.execution.getContext();
        return (XWikiContext)context.getProperty("xwikicontext");
    }

    public String getName() {
        return HINT;
    }

    public String getDescription() {
        return "Clear the index to purge sensitive data from the index.";
    }

    public XWikiDBVersion getVersion() {
        return new XWikiDBVersion(150502000);
    }

    public void migrate() throws DataMigrationException {
        try {
            this.solrInstance.deleteByQuery("*:*");
            this.solrInstance.commit();
        }
        catch (IOException | SolrServerException e) {
            throw new DataMigrationException("Error while performing Solr query to empty the search core", e);
        }
    }

    public boolean shouldExecute(XWikiDBVersion startupVersion) {
        XWikiDBVersion ltsVersion = new XWikiDBVersion(141015000);
        XWikiDBVersion afterLTSVersion = new XWikiDBVersion(150000000);
        return this.getXWikiContext().isMainWiki() && (startupVersion.compareTo(ltsVersion) < 0 || startupVersion.compareTo(afterLTSVersion) >= 0 && startupVersion.compareTo(this.getVersion()) < 0);
    }

    public String getPreHibernateLiquibaseChangeLog() throws DataMigrationException {
        return null;
    }

    public String getLiquibaseChangeLog() throws DataMigrationException {
        return null;
    }
}

