/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal.metadata;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.EntityReferenceSerializer;

@Component(roles={SolrLinkSerializer.class})
@Singleton
public class SolrLinkSerializer {
    private static final String ENTITY_PREFIX = "entity:";
    @Inject
    @Named(value="withtype/withparameters")
    private EntityReferenceSerializer<String> entitySerializer;
    @Inject
    @Named(value="withparameters")
    private EntityReferenceResolver<String> entityResolver;

    public String serialize(EntityReference reference) {
        return ENTITY_PREFIX + (String)this.entitySerializer.serialize(reference, new Object[0]);
    }

    public EntityReference unserialize(String link) {
        if (link.startsWith(ENTITY_PREFIX)) {
            return this.entityResolver.resolve((Object)link.substring(ENTITY_PREFIX.length()), null, new Object[0]);
        }
        return null;
    }
}

