/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal.metadata;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObjectReference;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.classes.PropertyClass;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.ObjectPropertyReference;
import org.xwiki.search.solr.internal.api.FieldUtils;
import org.xwiki.search.solr.internal.metadata.AbstractSolrMetadataExtractor;
import org.xwiki.search.solr.internal.metadata.TypedValue;
import org.xwiki.search.solr.internal.metadata.XWikiSolrInputDocument;
import org.xwiki.search.solr.internal.reference.SolrReferenceResolver;

@Component
@Named(value="object_property")
@Singleton
public class ObjectPropertySolrMetadataExtractor
extends AbstractSolrMetadataExtractor {
    @Inject
    @Named(value="object_property")
    private SolrReferenceResolver resolver;

    @Override
    public boolean setFieldsInternal(XWikiSolrInputDocument solrDocument, EntityReference entityReference) throws Exception {
        ObjectPropertyReference objectPropertyReference = new ObjectPropertyReference(entityReference);
        BaseObjectReference objectReference = new BaseObjectReference(objectPropertyReference.getParent());
        DocumentReference classReference = objectReference.getXClassReference();
        DocumentReference documentReference = new DocumentReference(objectReference.getParent());
        XWikiDocument originalDocument = this.getDocument(documentReference);
        BaseProperty objectProperty = originalDocument.getXObjectProperty(objectPropertyReference);
        if (objectProperty == null) {
            return false;
        }
        solrDocument.setField("class", this.localSerializer.serialize((EntityReference)classReference, new Object[0]));
        solrDocument.setField("number", objectReference.getObjectNumber());
        solrDocument.setField("propertyname", objectPropertyReference.getName());
        this.setLocaleAndContentFields(documentReference, solrDocument, (BaseProperty<ObjectPropertyReference>)objectProperty);
        this.extractorUtils.extract((EntityReference)objectPropertyReference, objectProperty, solrDocument);
        return true;
    }

    @Override
    protected void setPropertyValue(XWikiSolrInputDocument solrDocument, BaseProperty<?> property, TypedValue typedValue, Locale locale) {
        String fieldName = FieldUtils.getFieldName("propertyvalue", locale);
        this.addFieldValueOnce(solrDocument, fieldName, typedValue.getValue());
    }

    protected void setLocaleAndContentFields(DocumentReference documentReference, XWikiSolrInputDocument solrDocument, BaseProperty<ObjectPropertyReference> objectProperty) throws Exception {
        PropertyClass propertyClass = objectProperty.getPropertyClass((XWikiContext)this.xcontextProvider.get());
        for (Locale documentLocale : this.getLocales(documentReference, null)) {
            solrDocument.addField("locales", documentLocale);
            this.setPropertyValue(solrDocument, objectProperty, propertyClass, documentLocale);
        }
        this.setPropertyValue(solrDocument, objectProperty, propertyClass, null);
    }
}

