/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal.job;

import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.search.solr.internal.api.SolrIndexerException;
import org.xwiki.search.solr.internal.api.SolrInstance;
import org.xwiki.search.solr.internal.job.AbstractDocumentIterator;
import org.xwiki.search.solr.internal.reference.SolrReferenceResolver;

@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
@Named(value="solr")
public class SolrDocumentIterator
extends AbstractDocumentIterator<String> {
    private int index;
    private List<SolrDocument> results = Collections.emptyList();
    private SolrQuery query;
    @Inject
    private SolrInstance solrInstance;
    @Inject
    private SolrReferenceResolver solrReferenceResolver;
    @Inject
    private DocumentReferenceResolver<SolrDocument> solrDocumentReferenceResolver;

    @Override
    public boolean hasNext() {
        return this.getResults().size() > this.index;
    }

    @Override
    public Pair<DocumentReference, String> next() {
        List<SolrDocument> currentResults = this.getResults();
        if (currentResults.size() <= this.index) {
            throw new NoSuchElementException("No more element");
        }
        SolrDocument result = currentResults.get(this.index++);
        DocumentReference documentReference = this.solrDocumentReferenceResolver.resolve((Object)result, new Object[0]);
        String version = (String)result.get((Object)"version");
        return new ImmutablePair((Object)documentReference, (Object)version);
    }

    @Override
    public long size() {
        return this.getResults() instanceof SolrDocumentList ? ((SolrDocumentList)this.results).getNumFound() : (long)this.results.size();
    }

    private List<SolrDocument> getResults() {
        if (this.index >= this.results.size()) {
            try {
                String cursorMark = this.getQuery().get("cursorMark");
                QueryResponse response = this.solrInstance.query((SolrParams)this.query);
                if (cursorMark.equals(response.getNextCursorMark())) {
                    this.results = Collections.emptyList();
                } else {
                    this.results = response.getResults();
                    this.query.set("cursorMark", new String[]{response.getNextCursorMark()});
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to query the Solr index.", e);
            }
            this.index = 0;
        }
        return this.results;
    }

    private SolrQuery getQuery() throws SolrIndexerException {
        if (this.query == null) {
            this.query = new SolrQuery(this.solrReferenceResolver.getQuery(this.rootReference));
            this.query.setFields(new String[]{"wiki", "spaces", "name", "doclocale", "version"});
            this.query.addFilterQuery(new String[]{"type:" + EntityType.DOCUMENT.name()});
            this.query.addSort("wiki", SolrQuery.ORDER.asc);
            this.query.addSort("space_exact", SolrQuery.ORDER.asc);
            this.query.addSort("name_exact", SolrQuery.ORDER.asc);
            this.query.addSort("doclocale", SolrQuery.ORDER.asc);
            this.query.addSort("id", SolrQuery.ORDER.asc);
            this.query.set("cursorMark", new String[]{"*"});
            this.query.setRows(Integer.valueOf(this.getLimit()));
        }
        return this.query;
    }
}

