/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Singleton;
import org.apache.commons.collections4.MapUtils;
import org.apache.solr.client.solrj.request.schema.FieldTypeDefinition;
import org.apache.solr.client.solrj.request.schema.SchemaRequest;
import org.apache.solr.client.solrj.response.schema.FieldTypeRepresentation;
import org.apache.solr.client.solrj.response.schema.SchemaResponse;
import org.xwiki.component.annotation.Component;
import org.xwiki.search.solr.SolrException;
import org.xwiki.search.solr.XWikiSolrCore;

@Component(roles={SolrSchemaUtils.class})
@Singleton
public class SolrSchemaUtils {
    public static final String SOLR_TYPENAME_CVERSION = "__cversion";
    public static final String SOLR_VERSIONFIELDTYPE_VALUE = "defVal";
    private static final String SOLR_FIELD_NAME = "name";
    private final Map<String, SolrCoreSchema> coreSchemaMap = new HashMap<String, SolrCoreSchema>();

    private SolrCoreSchema getSchema(XWikiSolrCore core) {
        return this.coreSchemaMap.computeIfAbsent(core.getSolrName(), c -> new SolrCoreSchema());
    }

    public Map<String, FieldTypeRepresentation> getFieldTypes(XWikiSolrCore core, boolean force) throws SolrException {
        SolrCoreSchema schema = this.getSchema(core);
        if (schema.types == null || force) {
            SchemaResponse.FieldTypesResponse response;
            try {
                response = (SchemaResponse.FieldTypesResponse)new SchemaRequest.FieldTypes().process(core.getClient());
            }
            catch (Exception e) {
                throw new SolrException("Failed to get the list of field types", e);
            }
            HashMap<String, FieldTypeRepresentation> map = new HashMap<String, FieldTypeRepresentation>(response.getFieldTypes().size());
            response.getFieldTypes().forEach(t -> map.put((String)t.getAttributes().get(SOLR_FIELD_NAME), (FieldTypeRepresentation)t));
            schema.types = map;
        }
        return schema.types;
    }

    public Map<String, Map<String, Object>> getFields(XWikiSolrCore core, boolean force) throws SolrException {
        SolrCoreSchema schema = this.getSchema(core);
        if (schema.fields == null || force) {
            SchemaResponse.FieldsResponse response;
            try {
                response = (SchemaResponse.FieldsResponse)new SchemaRequest.Fields().process(core.getClient());
            }
            catch (Exception e2) {
                throw new SolrException("Failed to get the list of fields", e2);
            }
            ConcurrentHashMap<String, Map<String, Object>> map = new ConcurrentHashMap<String, Map<String, Object>>(response.getFields().size());
            response.getFields().forEach(e -> map.put((String)e.get(SOLR_FIELD_NAME), (Map<String, Object>)e));
            schema.fields = map;
        }
        return schema.fields;
    }

    public Map<String, Map<String, Object>> getDynamicFields(XWikiSolrCore core, boolean force) throws SolrException {
        SolrCoreSchema schema = this.getSchema(core);
        if (schema.dynamicFields == null || force) {
            SchemaResponse.DynamicFieldsResponse response;
            try {
                response = (SchemaResponse.DynamicFieldsResponse)new SchemaRequest.DynamicFields().process(core.getClient());
            }
            catch (Exception e2) {
                throw new SolrException("Failed to get the list of dynamic fields", e2);
            }
            ConcurrentHashMap<String, Map<String, Object>> map = new ConcurrentHashMap<String, Map<String, Object>>(response.getDynamicFields().size());
            response.getDynamicFields().forEach(e -> map.put((String)e.get(SOLR_FIELD_NAME), (Map<String, Object>)e));
            schema.dynamicFields = map;
        }
        return schema.dynamicFields;
    }

    public Map<String, Set<String>> getCopyFields(XWikiSolrCore core, boolean force) throws SolrException {
        SolrCoreSchema schema = this.getSchema(core);
        if (schema.copyFields == null || force) {
            SchemaResponse.CopyFieldsResponse response;
            try {
                response = (SchemaResponse.CopyFieldsResponse)new SchemaRequest.CopyFields().process(core.getClient());
            }
            catch (Exception e) {
                throw new SolrException("Failed to get the list of copy fields", e);
            }
            ConcurrentHashMap<String, Set<String>> map = new ConcurrentHashMap<String, Set<String>>(response.getCopyFields().size());
            for (Map fields : response.getCopyFields()) {
                Set destinations = map.computeIfAbsent((String)fields.get("source"), k -> ConcurrentHashMap.newKeySet());
                destinations.add((String)fields.get("dest"));
            }
            schema.copyFields = map;
        }
        return schema.copyFields;
    }

    public void setFieldType(XWikiSolrCore core, FieldTypeDefinition definition, boolean add) throws SolrException {
        SolrCoreSchema schema = this.getSchema(core);
        try {
            if (add) {
                new SchemaRequest.AddFieldType(definition).process(core.getClient());
            } else {
                new SchemaRequest.ReplaceFieldType(definition).process(core.getClient());
            }
        }
        catch (Exception e) {
            throw new SolrException("Failed to add a field type in the Solr core", e);
        }
        FieldTypeRepresentation representation = new FieldTypeRepresentation();
        representation.setAttributes(definition.getAttributes());
        representation.setAnalyzer(definition.getAnalyzer());
        representation.setIndexAnalyzer(definition.getIndexAnalyzer());
        representation.setMultiTermAnalyzer(definition.getMultiTermAnalyzer());
        representation.setQueryAnalyzer(definition.getQueryAnalyzer());
        representation.setSimilarity(definition.getSimilarity());
        this.getFieldTypes(core, false).put((String)definition.getAttributes().get(SOLR_FIELD_NAME), representation);
    }

    public void setField(XWikiSolrCore core, Map<String, Object> fieldAttributes, boolean dynamic) throws SolrException {
        String name = (String)fieldAttributes.get(SOLR_FIELD_NAME);
        if (dynamic) {
            this.setField(core, fieldAttributes, dynamic, !this.getDynamicFields(core, false).containsKey(name));
        } else {
            this.setField(core, fieldAttributes, dynamic, !this.getFields(core, false).containsKey(name));
        }
    }

    public void setField(XWikiSolrCore core, Map<String, Object> fieldAttributes, boolean dynamic, boolean add) throws SolrException {
        String name = (String)fieldAttributes.get(SOLR_FIELD_NAME);
        try {
            if (dynamic) {
                if (add) {
                    new SchemaRequest.AddDynamicField(fieldAttributes).process(core.getClient());
                } else {
                    new SchemaRequest.ReplaceDynamicField(fieldAttributes).process(core.getClient());
                }
                this.getDynamicFields(core, false).put(name, fieldAttributes);
            } else {
                if (add) {
                    new SchemaRequest.AddField(fieldAttributes).process(core.getClient());
                } else {
                    new SchemaRequest.ReplaceField(fieldAttributes).process(core.getClient());
                }
                this.getFields(core, false).put(name, fieldAttributes);
            }
        }
        catch (Exception e) {
            throw new SolrException(String.format("Failed to set the field [%s] in the Solr core (dynamic: [%s])", name, dynamic), e);
        }
    }

    public void setField(XWikiSolrCore core, String name, String type, boolean dynamic, Object ... attributes) throws SolrException {
        HashMap<String, Object> fieldAttributes = new HashMap<String, Object>();
        fieldAttributes.put(SOLR_FIELD_NAME, name);
        fieldAttributes.put("type", type);
        MapUtils.putAll(fieldAttributes, (Object[])attributes);
        this.setField(core, fieldAttributes, dynamic);
    }

    public void setField(XWikiSolrCore core, String name, String type, boolean dynamic, boolean add, Object ... attributes) throws SolrException {
        HashMap<String, Object> fieldAttributes = new HashMap<String, Object>();
        fieldAttributes.put(SOLR_FIELD_NAME, name);
        fieldAttributes.put("type", type);
        MapUtils.putAll(fieldAttributes, (Object[])attributes);
        this.setField(core, fieldAttributes, dynamic, add);
    }

    public void deleteField(XWikiSolrCore core, String name, boolean dynamic) throws SolrException {
        try {
            if (dynamic) {
                new SchemaRequest.DeleteDynamicField(name).process(core.getClient());
            } else {
                new SchemaRequest.DeleteField(name).process(core.getClient());
            }
            this.getFields(core, false).remove(name);
        }
        catch (Exception e) {
            throw new SolrException(String.format("Failed to delete the field [%s] (dynamic: [%s])", name, dynamic), e);
        }
    }

    public void addCopyField(XWikiSolrCore core, String source, String ... destinations) throws SolrException {
        this.addCopyField(core, source, List.of(destinations));
    }

    public void addCopyField(XWikiSolrCore core, String source, List<String> destinations) throws SolrException {
        try {
            new SchemaRequest.AddCopyField(source, destinations).process(core.getClient());
            this.getCopyFields(core, false).computeIfAbsent(source, k -> ConcurrentHashMap.newKeySet()).addAll(destinations);
        }
        catch (Exception e) {
            throw new SolrException("Failed to add a copy field in the Solr core", e);
        }
    }

    public void commit(XWikiSolrCore core) throws SolrException {
        try {
            core.getClient().commit();
        }
        catch (Exception e) {
            throw new SolrException("Failed to commit", e);
        }
        this.getSchema(core).reset();
    }

    private static final class SolrCoreSchema {
        private Map<String, FieldTypeRepresentation> types;
        private Map<String, Map<String, Object>> fields;
        private Map<String, Map<String, Object>> dynamicFields;
        private Map<String, Set<String>> copyFields;

        private SolrCoreSchema() {
        }

        void reset() {
            this.types = null;
            this.fields = null;
            this.dynamicFields = null;
            this.copyFields = null;
        }
    }
}

