/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.internal.reference.AbstractEntityReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceProvider;
import org.xwiki.model.reference.EntityReferenceResolver;

@Component
@Named(value="solr")
@Singleton
public class SolrFieldStringEntityReferenceResolver
extends AbstractEntityReferenceResolver
implements EntityReferenceResolver<String> {
    static final char SEPARATOR = '.';
    private static final Map<EntityType, EntityType[]> ENTITY_TYPES = new HashMap<EntityType, EntityType[]>(){
        {
            this.put(EntityType.DOCUMENT, new EntityType[]{EntityType.DOCUMENT, EntityType.SPACE, EntityType.WIKI});
            this.put(EntityType.ATTACHMENT, new EntityType[]{EntityType.ATTACHMENT, EntityType.DOCUMENT, EntityType.SPACE, EntityType.WIKI});
            this.put(EntityType.SPACE, new EntityType[]{EntityType.SPACE, EntityType.WIKI});
            this.put(EntityType.OBJECT, new EntityType[]{EntityType.OBJECT, EntityType.DOCUMENT, EntityType.SPACE, EntityType.WIKI});
            this.put(EntityType.OBJECT_PROPERTY, new EntityType[]{EntityType.OBJECT_PROPERTY, EntityType.OBJECT, EntityType.DOCUMENT, EntityType.SPACE, EntityType.WIKI});
            this.put(EntityType.CLASS_PROPERTY, new EntityType[]{EntityType.CLASS_PROPERTY, EntityType.DOCUMENT, EntityType.SPACE, EntityType.WIKI});
        }
    };
    @Inject
    @Named(value="current")
    private EntityReferenceProvider currentEntityReferenceProvider;

    public EntityReference resolve(String entityReferenceRepresentation, EntityType type, Object ... parameters) {
        EntityReference parent;
        EntityType[] entityTypesForType = ENTITY_TYPES.get(type);
        if (entityTypesForType == null) {
            throw new RuntimeException("No parsing definition found for Entity Type [" + String.valueOf(type) + "]");
        }
        EntityReference entityReference = null;
        int entityTypeOffset = 0;
        int offset = entityReferenceRepresentation.length() - 1;
        while (offset >= 0) {
            entityTypeOffset = Math.min(entityTypeOffset, entityTypesForType.length - 2);
            StringBuilder entityName = new StringBuilder();
            offset = this.readEntityName(entityReferenceRepresentation, entityName, offset);
            parent = this.getNewEntityReference(entityName.reverse().toString(), entityTypesForType[entityTypeOffset++], parameters);
            entityReference = entityReference == null ? parent : entityReference.appendParent(parent);
        }
        for (int i = entityTypeOffset; i < entityTypesForType.length && (parent = this.resolveDefaultReference(entityTypesForType[i], parameters)) != null; ++i) {
            entityReference = entityReference == null ? parent : entityReference.appendParent(parent);
        }
        return entityReference;
    }

    private int readCharacter(String input, StringBuilder output, int offset) {
        if (offset >= 0) {
            char c = input.charAt(offset);
            if (c == '.') {
                if (offset == 0 || offset > 0 && input.charAt(offset - 1) != '.') {
                    return offset;
                }
                output.append(c);
                return offset - 2;
            }
            output.append(c);
            return offset - 1;
        }
        return offset;
    }

    private int readEntityName(String input, StringBuilder output, int inputOffset) {
        int oldOffset;
        int offset = inputOffset;
        do {
            oldOffset = offset;
        } while ((offset = this.readCharacter(input, output, offset)) != oldOffset);
        return offset - 1;
    }

    private EntityReference getNewEntityReference(String name, EntityType type, Object ... parameters) {
        if ("".equals(name)) {
            return this.resolveDefaultReference(type, parameters);
        }
        return new EntityReference(name, type);
    }

    protected EntityReference getDefaultReference(EntityType type, Object ... parameters) {
        return this.currentEntityReferenceProvider.getDefaultReference(type);
    }
}

