/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.AbstractMandatoryDocumentInitializer;
import com.xpn.xwiki.doc.XWikiDocument;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.search.solr.internal.DefaultIndexingUserConfig;

@Component
@Named(value="XWiki.SolrSearchAdminIndexingUser")
@Singleton
@Priority(value=1100)
public class IndexingUserConfigurationInitializer
extends AbstractMandatoryDocumentInitializer {
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private Logger logger;

    public IndexingUserConfigurationInitializer() {
        super((EntityReference)DefaultIndexingUserConfig.CONFIG_PAGE);
    }

    public boolean isMainWikiOnly() {
        return true;
    }

    protected boolean updateDocumentFields(XWikiDocument document, String title) {
        boolean needsUpdate = super.updateDocumentFields(document, title);
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        if (document.getXObject((EntityReference)DefaultIndexingUserConfig.CONFIG_CLASS) == null) {
            try {
                document.newXObject((EntityReference)DefaultIndexingUserConfig.CONFIG_CLASS, context);
                needsUpdate = true;
            }
            catch (XWikiException e) {
                this.logger.error(String.format("Error adding the [%s] object to the document [%s]", DefaultIndexingUserConfig.CONFIG_CLASS, document.getDocumentReference()), (Throwable)e);
            }
        }
        return needsUpdate;
    }
}

