/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.lucene.util.Version;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.DisposePriority;
import org.xwiki.component.phase.Disposable;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.environment.Environment;
import org.xwiki.search.solr.SolrCoreInitializer;
import org.xwiki.search.solr.SolrException;
import org.xwiki.search.solr.internal.AbstractSolr;
import org.xwiki.search.solr.internal.XWikiCoreContainer;
import org.xwiki.search.solr.internal.api.SolrConfiguration;

@Component
@Named(value="embedded")
@Singleton
@DisposePriority(value=10000)
public class EmbeddedSolr
extends AbstractSolr
implements Disposable,
Initializable {
    public static final String TYPE = "embedded";
    private static final String SOLRCONFIG_PATH = "conf/solrconfig.xml";
    private static final String SCHEMA_PATH = "conf/managed-schema.xml";
    private static final long SEARCH_CORE_SCHEMA_VERSION = 160600000L;
    private static final String CORE_PROPERTIES_FILENAME = "core.properties";
    private static final String DATA_DIR_PROPERTY = "dataDir";
    @Inject
    private SolrConfiguration solrConfiguration;
    @Inject
    private Environment environment;
    private CoreContainer container;
    private Path solrHomePath;
    private Path solrSearchCorePath;

    public void initialize() throws InitializationException {
        this.solrHomePath = Paths.get(this.solrConfiguration.getHomeDirectory(), new String[0]).toAbsolutePath();
        this.solrSearchCorePath = this.solrHomePath.resolve(this.toSolrCoreName("search"));
        try {
            if (!Files.exists(this.solrHomePath, new LinkOption[0])) {
                this.createHomeDirectory();
            } else {
                this.updateHomeDirectory();
            }
            System.setProperty("solr.install.dir", this.solrHomePath.toString());
            if (Files.exists(this.solrSearchCorePath, new LinkOption[0])) {
                if (!this.isSearchCoreValid()) {
                    this.recreateSearchCore();
                }
            } else {
                Path pre1601Path = this.solrHomePath.resolve("search");
                if (Files.exists(pre1601Path, new LinkOption[0])) {
                    FileUtils.deleteDirectory((File)pre1601Path.toFile());
                }
                this.createSearchCore();
            }
            this.logger.info("Starting embedded Solr server...");
            this.logger.info("Using Solr home directory: [{}]", (Object)this.solrHomePath);
            this.container = this.createCoreContainer();
            this.logger.info("Started embedded Solr server.");
        }
        catch (Exception e) {
            throw new InitializationException(String.format("Failed to initialize the Solr embedded server with home directory set to [%s]", this.solrHomePath), (Throwable)e);
        }
    }

    private CoreContainer createCoreContainer() throws SolrServerException {
        CoreContainer coreContainer = XWikiCoreContainer.createAndLoad(this.solrHomePath);
        Map failures = coreContainer.getCoreInitFailures();
        if (MapUtils.isNotEmpty((Map)failures)) {
            for (Map.Entry failure : failures.entrySet()) {
                this.logger.error("Failed to initialize Solr core with id [{}]", failure.getKey(), (Object)((CoreContainer.CoreLoadFailure)failure.getValue()).exception);
            }
            if (coreContainer.getLoadedCoreNames().isEmpty()) {
                throw new SolrServerException("Failed to initialize the Solr core. Please check previous log messages.");
            }
        }
        return coreContainer;
    }

    @Override
    protected SolrClient getInternalSolrClient(String coreName) throws SolrException {
        SolrCore core = this.container.getCore(coreName);
        return core != null ? new EmbeddedSolrServer(core) : null;
    }

    @Override
    protected SolrClient createSolrClient(String solrCoreName, boolean isCache) throws SolrException {
        Path corePath;
        try {
            corePath = this.prepareCore(solrCoreName);
        }
        catch (IOException e) {
            throw new SolrException("Failed to prepare the Solr core storage", e);
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (isCache) {
            parameters.put(DATA_DIR_PROPERTY, this.getCacheCoreDataDir(corePath, solrCoreName).toString());
        }
        parameters.put("loadOnStartup", "false");
        SolrCore core = this.container.create(solrCoreName, parameters);
        return new EmbeddedSolrServer(core);
    }

    private Path prepareCore(String solrCoreName) throws IOException {
        Path corePath = this.container.getConfig().getCoreRootDirectory().resolve(solrCoreName);
        Files.createDirectory(corePath, new FileAttribute[0]);
        try (InputStream stream = this.solrConfiguration.getMinimalCoreDefaultContent();){
            this.copyCoreConfiguration(stream, corePath, true, null);
        }
        return corePath;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.container != null) {
            this.container.shutdown();
        }
    }

    @Override
    protected int getSolrMajorVersion() {
        return Version.LATEST.major;
    }

    protected CoreContainer getContainer() {
        return this.container;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Version getLuceneVersion(File solrconfigFile) {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.supportDTD", false);
        try (FileReader reader = new FileReader(solrconfigFile);){
            XMLStreamReader xmlReader = factory.createXMLStreamReader(reader);
            xmlReader.nextTag();
            while (xmlReader.isStartElement()) {
                if (xmlReader.getLocalName().equals("luceneMatchVersion")) {
                    Version version = Version.parse((String)xmlReader.getElementText());
                    return version;
                }
                xmlReader.nextTag();
            }
            return null;
        }
        catch (Exception e) {
            this.logger.warn("Failed to parse Solr configuration at [{}]: {}", (Object)solrconfigFile, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getCoreVersion(File schemaFile) {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.supportDTD", false);
        try (FileReader reader = new FileReader(schemaFile);){
            XMLStreamReader xmlReader = factory.createXMLStreamReader(reader);
            xmlReader.nextTag();
            while (xmlReader.isStartElement()) {
                if (xmlReader.getLocalName().equals("fieldType") && "__cversion".equals(xmlReader.getAttributeValue(null, "name"))) {
                    String version = xmlReader.getAttributeValue(null, "defVal");
                    if (version == null) return -1L;
                    long l = NumberUtils.createLong((String)version);
                    return l;
                }
                xmlReader.nextTag();
            }
            return -1L;
        }
        catch (Exception e) {
            this.logger.warn("Failed to parse Solr configuration at [{}]: {}", (Object)schemaFile, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        return -1L;
    }

    private boolean isSearchCoreValid() throws IOException {
        File corePropertiesFile = this.getCacheCorePropertiesFile(this.solrSearchCorePath);
        if (corePropertiesFile.exists()) {
            Properties properties = new Properties();
            try (FileInputStream in = new FileInputStream(corePropertiesFile);){
                properties.load(in);
            }
            String dataDirPropertyValue = properties.getProperty(DATA_DIR_PROPERTY);
            if (dataDirPropertyValue != null && !dataDirPropertyValue.contains(File.separator)) {
                this.logger.info("Found XWIKI-22741 bug!");
                File badCacheLocation = new File(corePropertiesFile.getParent(), dataDirPropertyValue);
                if (badCacheLocation.exists()) {
                    this.logger.info("Removing old Solr Search Cache files from: " + badCacheLocation.getAbsolutePath());
                    FileUtils.deleteDirectory((File)badCacheLocation);
                }
                return false;
            }
        }
        if (!(Files.isDirectory(this.solrSearchCorePath, new LinkOption[0]) && Files.isWritable(this.solrSearchCorePath) && Files.isReadable(this.solrSearchCorePath))) {
            throw new IllegalArgumentException(String.format("The given path [%s] must be a readable and writable directory", this.solrSearchCorePath));
        }
        File solrconfigFile = this.solrSearchCorePath.resolve(SOLRCONFIG_PATH).toFile();
        if (!solrconfigFile.exists() || !Version.LATEST.equals((Object)this.getLuceneVersion(solrconfigFile))) {
            return false;
        }
        File schemaFile = this.solrSearchCorePath.resolve(SCHEMA_PATH).toFile();
        return schemaFile.exists() && 160600000L <= this.getCoreVersion(schemaFile);
    }

    private void recreateSearchCore() throws IOException {
        if (Files.exists(this.solrSearchCorePath, new LinkOption[0])) {
            this.logger.warn("The Solr search core directory at [{}] is invalid. Deleting it and creating a new one.", (Object)this.solrSearchCorePath);
            FileUtils.deleteDirectory((File)this.solrSearchCorePath.toFile());
            FileUtils.deleteDirectory((File)this.resolveCacheCoreDataPath(this.toSolrCoreName("search")).toFile());
        }
        this.createSearchCore();
    }

    private void writeHomeConfiguration() throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append("<solr>");
        builder.append("<logging><str name=\"enabled\">false</str></logging>");
        builder.append("</solr>");
        FileUtils.write((File)this.solrHomePath.resolve("solr.xml").toFile(), (CharSequence)builder.toString(), (Charset)StandardCharsets.UTF_8);
    }

    private void createHomeDirectory() throws IOException {
        this.logger.info("Generating a new Solr home directory at [{}]", (Object)this.solrHomePath);
        Files.createDirectories(this.solrHomePath, new FileAttribute[0]);
        this.writeHomeConfiguration();
        File oldHome = new File(this.environment.getPermanentDirectory(), "solr");
        if (oldHome.exists()) {
            for (File file : oldHome.listFiles()) {
                if (!file.isDirectory() || file.getName().equals("xwiki") || file.getName().equals("META-INF")) continue;
                FileUtils.moveDirectoryToDirectory((File)file, (File)this.solrHomePath.toFile(), (boolean)false);
            }
        }
    }

    private void updateHomeDirectory() throws IOException {
        this.logger.info("Updating Solr home directory at [{}]", (Object)this.solrHomePath);
        this.writeHomeConfiguration();
        try (Stream<Path> stream = Files.list(this.solrHomePath);){
            stream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(this::updateCore);
        }
    }

    private void updateCore(Path corePath) {
        block8: {
            try {
                Version luceneVersion;
                Path solrconfig;
                if (!this.componentManager.hasComponent(SolrCoreInitializer.class, this.toXWikiCoreName(corePath.getFileName().toString())) || !Files.exists(solrconfig = corePath.resolve(SOLRCONFIG_PATH), new LinkOption[0]) || (luceneVersion = this.getLuceneVersion(solrconfig.toFile())) != null && this.getSolrMajorVersion() != luceneVersion.major) break block8;
                try (InputStream stream = this.solrConfiguration.getMinimalCoreDefaultContent();){
                    this.copyCoreConfiguration(stream, corePath, true, Set.of(SOLRCONFIG_PATH));
                }
            }
            catch (Exception e) {
                this.logger.error("Failed to update Solr core located at [{}]", (Object)corePath, (Object)e);
            }
        }
    }

    private void copyCoreConfiguration(InputStream stream, Path corePath, boolean skipCoreProperties, Set<String> force) throws IOException {
        try (ZipInputStream zstream = new ZipInputStream(stream);){
            ZipEntry entry = zstream.getNextEntry();
            while (entry != null) {
                Path targetPath = corePath.resolve(entry.getName());
                if (entry.isDirectory()) {
                    Files.createDirectories(targetPath, new FileAttribute[0]);
                } else if (force != null && force.contains(entry.getName()) || !Files.exists(targetPath, new LinkOption[0]) && (!skipCoreProperties || !entry.getName().equals(CORE_PROPERTIES_FILENAME))) {
                    FileUtils.copyInputStreamToFile((InputStream)CloseShieldInputStream.wrap((InputStream)zstream), (File)targetPath.toFile());
                }
                entry = zstream.getNextEntry();
            }
        }
    }

    private void createSearchCore() throws IOException {
        this.copyCoreConfiguration(this.solrConfiguration.getSearchCoreDefaultContent(), this.solrSearchCorePath, false, null);
        this.createCacheCore(this.solrSearchCorePath, this.toSolrCoreName("search"));
    }

    private File getCacheCorePropertiesFile(Path corePath) {
        File corePropertiesFile = corePath.resolve(CORE_PROPERTIES_FILENAME).toFile();
        return corePropertiesFile;
    }

    private void createCacheCore(Path corePath, String solrCoreName) throws IOException {
        Path dataDir = this.getCacheCoreDataDir(corePath, solrCoreName);
        File corePropertiesFile = this.getCacheCorePropertiesFile(corePath);
        Properties coreProperties = new Properties();
        coreProperties.setProperty(DATA_DIR_PROPERTY, dataDir.toString());
        try (FileOutputStream out = new FileOutputStream(corePropertiesFile, false);){
            coreProperties.store(out, "");
        }
    }

    private Path getCacheCoreDataDir(Path corePath, String solrCoreName) {
        return corePath.relativize(this.resolveCacheCoreDataPath(solrCoreName));
    }

    private Path resolveCacheCoreDataPath(String solrCoreName) {
        return this.environment.getPermanentDirectory().toPath().resolve("cache/solr/" + solrCoreName).toAbsolutePath();
    }
}

