/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal;

import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrInputDocument;
import org.xwiki.component.annotation.Component;
import org.xwiki.properties.ConverterManager;
import org.xwiki.search.solr.SolrUtils;

@Component
@Singleton
public class DefaultSolrUtils
implements SolrUtils {
    public static final String SOLR_TYPE_STRING = "string";
    public static final String SOLR_TYPE_STRINGS = "strings";
    public static final String SOLR_TYPE_BOOLEAN = "boolean";
    public static final String SOLR_TYPE_BOOLEANS = "booleans";
    public static final String SOLR_TYPE_PINT = "pint";
    public static final String SOLR_TYPE_PINTS = "pints";
    public static final String SOLR_TYPE_PFLOAT = "pfloat";
    public static final String SOLR_TYPE_PFLOATS = "pfloats";
    public static final String SOLR_TYPE_PLONG = "plong";
    public static final String SOLR_TYPE_PLONGS = "plongs";
    public static final String SOLR_TYPE_PDOUBLE = "pdouble";
    public static final String SOLR_TYPE_PDOUBLES = "pdoubles";
    public static final String SOLR_TYPE_PDATE = "pdate";
    public static final String SOLR_TYPE_PDATES = "pdates";
    public static final String SOLR_TYPE_BINARY = "binary";
    public static final String SOLR_TYPE_TEXT_GENERAL = "text_general";
    public static final String SOLR_TYPE_TEXT_GENERALS = "text_generals";
    private static final String PATTERN_GROUP = "(.+)";
    private static final String PATTERN_EMPTY_STRING = "\"\"";
    private static final Pattern PATTERN_OR_AND_NOT = Pattern.compile("(OR|AND|NOT)");
    private static final TypeVariable<Class<Iterable>> ITERABLE_PARAMETER = Iterable.class.getTypeParameters()[0];
    private static final Map<Class<?>, String> CLASS_SUFFIX_MAPPING = new HashMap();
    @Inject
    private ConverterManager converter;

    public static String getTypeName(Object value) {
        if (value == null) {
            return null;
        }
        Object typeName = CLASS_SUFFIX_MAPPING.get(value.getClass());
        if (typeName != null) {
            return typeName;
        }
        if (value instanceof Collection) {
            typeName = DefaultSolrUtils.getTypeName((Collection)value);
        } else if (value.getClass().isArray()) {
            typeName = DefaultSolrUtils.getTypeName(value.getClass().getComponentType());
            if (typeName != null) {
                typeName = (String)typeName + "s";
            }
        } else {
            typeName = DefaultSolrUtils.getTypeName(value.getClass());
        }
        return typeName;
    }

    private static String getTypeName(Iterable<?> collection) {
        String typeName = null;
        for (Object element : collection) {
            if (element == null) continue;
            String elementType = DefaultSolrUtils.getTypeName(element);
            if (elementType == null || typeName != null && typeName != elementType) {
                return null;
            }
            typeName = elementType;
        }
        return (typeName != null ? typeName : SOLR_TYPE_STRING) + "s";
    }

    private static String getTypeName(Class<?> clazz) {
        if (clazz != null) {
            String typeName = CLASS_SUFFIX_MAPPING.get(clazz);
            if (typeName != null) {
                return typeName;
            }
            if (Iterable.class.isAssignableFrom(clazz)) {
                return SOLR_TYPE_STRINGS;
            }
            if (clazz.isArray() && (typeName = DefaultSolrUtils.getTypeName(clazz.getComponentType())) != null) {
                return typeName + "s";
            }
        }
        return null;
    }

    private static boolean isList(Class<?> clazz) {
        if (clazz != null && !CLASS_SUFFIX_MAPPING.containsKey(clazz)) {
            return Iterable.class.isAssignableFrom(clazz) || clazz.isArray();
        }
        return false;
    }

    private static String getTypeName(Type type) {
        if (type != null) {
            Type rawType;
            if (type instanceof Class) {
                return DefaultSolrUtils.getTypeName((Class)type);
            }
            if (type instanceof ParameterizedType && (rawType = ((ParameterizedType)type).getRawType()) instanceof Class && Iterable.class.isAssignableFrom((Class)rawType)) {
                Map variables = TypeUtils.getTypeArguments((Type)type, Iterable.class);
                return DefaultSolrUtils.getIterableTypeName((Type)variables.get(ITERABLE_PARAMETER));
            }
        }
        return null;
    }

    private static String getIterableTypeName(Type elementType) {
        String elementTypeName;
        if (elementType instanceof Class && (elementTypeName = CLASS_SUFFIX_MAPPING.get(elementType)) != null) {
            return elementTypeName + "s";
        }
        return null;
    }

    public static String getMapDynamicFieldName(String mapFieldName, String type) {
        return DefaultSolrUtils.getMapFieldName("*", mapFieldName, type);
    }

    public static Pattern getMapFieldPattern(String mapFieldName) {
        return Pattern.compile(DefaultSolrUtils.getMapFieldName(PATTERN_GROUP, mapFieldName, PATTERN_GROUP));
    }

    public static String getMapFieldName(String key, String mapFieldName, String type) {
        return key + "__" + mapFieldName + "_" + (type != null ? type : SOLR_TYPE_STRING);
    }

    @Override
    public String getMapFieldName(String key, String mapFieldName, Type type) {
        return DefaultSolrUtils.getMapFieldName(key, mapFieldName, DefaultSolrUtils.getTypeName(type));
    }

    public Map<String, Object> getMap(String mapFieldName, SolrDocument document) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Pattern pattern = DefaultSolrUtils.getMapFieldPattern(mapFieldName);
        for (String fieldName : document.getFieldNames()) {
            Matcher matcher = pattern.matcher(fieldName);
            if (!matcher.matches()) continue;
            map.put(matcher.group(1), document.getFieldValue(fieldName));
        }
        return map;
    }

    @Override
    public void setMap(String mapFieldName, Map<String, ?> fieldValue, SolrInputDocument document) {
        fieldValue.forEach((key, value) -> {
            if (value != null) {
                Object typeName = CLASS_SUFFIX_MAPPING.get(value.getClass());
                if (typeName != null) {
                    document.setField(DefaultSolrUtils.getMapFieldName(key, mapFieldName, (String)typeName), value);
                } else if (value instanceof Iterable) {
                    typeName = DefaultSolrUtils.getTypeName((Iterable)value);
                    if (typeName != null) {
                        for (Object element : (Iterable)value) {
                            document.addField(DefaultSolrUtils.getMapFieldName(key, mapFieldName, (String)typeName), element);
                        }
                    }
                } else if (value.getClass().isArray()) {
                    typeName = DefaultSolrUtils.getTypeName(value.getClass().getComponentType());
                    if (typeName != null) {
                        typeName = (String)typeName + "s";
                        for (int i = 0; i < Array.getLength(value); ++i) {
                            document.addField(DefaultSolrUtils.getMapFieldName(key, mapFieldName, (String)typeName), Array.get(value, i));
                        }
                    }
                    if (typeName != null) {
                        typeName = (String)typeName + "s";
                    }
                }
            }
        });
    }

    @Override
    public String getId(SolrDocument document) {
        return (String)this.get("id", document);
    }

    @Override
    public <T> T get(String fieldName, SolrDocument document) {
        return (T)document.getFieldValue(fieldName);
    }

    @Override
    public <T> T get(String fieldName, SolrDocument document, T def) {
        if (document.containsKey((Object)fieldName)) {
            if (def != null) {
                return this.get(fieldName, document, def.getClass());
            }
            return (T)document.getFieldValue(fieldName);
        }
        return def;
    }

    @Override
    public void setId(Object fieldValue, SolrInputDocument document) {
        this.set("id", fieldValue, document);
    }

    @Override
    public void set(String fieldName, Object fieldValue, SolrInputDocument document) {
        document.setField(fieldName, fieldValue);
    }

    @Override
    public void set(String fieldName, Collection<?> fieldValue, SolrInputDocument document) {
        document.removeField(fieldName);
        fieldValue.forEach(e -> document.addField(fieldName, e));
    }

    @Override
    public void setAtomic(String modifier, String fieldName, Object fieldValue, SolrInputDocument document) {
        document.setField(fieldName, Collections.singletonMap(modifier, fieldValue));
    }

    @Override
    public void setAtomic(String modifier, String fieldName, Object fieldValue, Type valueType, SolrInputDocument document) {
        document.setField(fieldName, Collections.singletonMap(modifier, this.toString(fieldValue, valueType)));
    }

    @Override
    public void setString(String fieldName, Object fieldValue, SolrInputDocument document) {
        document.setField(fieldName, (Object)this.toString(fieldValue));
    }

    @Override
    public void setString(String fieldName, Object fieldValue, Type valueType, SolrInputDocument document) {
        document.setField(fieldName, (Object)this.toString(fieldValue, valueType));
    }

    @Override
    public void setString(String fieldName, Collection<?> fieldValue, Type valueType, SolrInputDocument document) {
        document.removeField(fieldName);
        fieldValue.forEach(e -> document.addField(fieldName, (Object)this.toString(e, valueType)));
    }

    private String toString(Object fieldValue, Type valueType) {
        if (fieldValue == null) {
            return null;
        }
        Object value = fieldValue;
        if (!TypeUtils.isInstance((Object)fieldValue, (Type)valueType)) {
            value = this.converter.convert(valueType, fieldValue);
        }
        String str = value instanceof String ? (String)value : (CLASS_SUFFIX_MAPPING.containsKey(fieldValue.getClass()) ? value.toString() : (String)this.converter.getConverter(valueType).convert(String.class, fieldValue));
        return str;
    }

    private String toString(Object fieldValue) {
        if (fieldValue == null) {
            return null;
        }
        String str = fieldValue instanceof String ? (String)fieldValue : (CLASS_SUFFIX_MAPPING.containsKey(fieldValue.getClass()) ? fieldValue.toString() : (String)this.converter.convert(String.class, fieldValue));
        return str;
    }

    private String toFilterQueryString(String fieldValue) {
        String escaped = ClientUtils.escapeQueryChars((String)fieldValue);
        escaped = PATTERN_OR_AND_NOT.matcher(escaped).replaceAll("\\\\$1");
        return escaped;
    }

    @Override
    public String toFilterQueryString(Object fieldValue) {
        if (fieldValue == null) {
            return null;
        }
        String str = fieldValue instanceof Date ? ((Date)fieldValue).toInstant().toString() : this.toFilterQueryString(this.toString(fieldValue));
        return str;
    }

    @Override
    public String toFilterQueryString(Object fieldValue, Type valueType) {
        if (fieldValue == null) {
            return null;
        }
        Object value = fieldValue;
        if (!TypeUtils.isInstance((Object)fieldValue, (Type)valueType)) {
            value = this.converter.convert(valueType, fieldValue);
        }
        String str = value instanceof Date ? ((Date)value).toInstant().toString() : this.toFilterQueryString(this.toString(value, valueType));
        return str;
    }

    @Override
    public String toCompleteFilterQueryString(Object fieldValue) {
        String result = this.toFilterQueryString(fieldValue);
        if ("".equals(result)) {
            result = PATTERN_EMPTY_STRING;
        }
        return result;
    }

    @Override
    public String toCompleteFilterQueryString(Object fieldValue, Type valueType) {
        String result = this.toFilterQueryString(fieldValue, valueType);
        if ("".equals(result)) {
            result = PATTERN_EMPTY_STRING;
        }
        return result;
    }

    @Override
    public <T> T get(String fieldName, SolrDocument document, Type targetType) {
        return this.toValue(this.get(fieldName, document), targetType);
    }

    private <T> T toValue(Object storedValue, Type targetType) {
        if (!(storedValue != null || targetType instanceof Class && ((Class)targetType).isPrimitive())) {
            return null;
        }
        return (T)this.converter.convert(targetType, storedValue);
    }

    @Override
    public <T> Collection<T> getCollection(String fieldName, SolrDocument document) {
        return document.getFieldValues(fieldName);
    }

    @Override
    public <T> Collection<T> getCollection(String fieldName, SolrDocument document, Type targetType) {
        return this.getList(fieldName, document, targetType);
    }

    @Override
    public <T> List<T> getList(String fieldName, SolrDocument document, Type targetType) {
        Collection solrCollection = document.getFieldValues(fieldName);
        if (solrCollection == null) {
            return null;
        }
        ArrayList collection = new ArrayList(solrCollection.size());
        solrCollection.forEach(e -> collection.add(this.toValue(e, targetType)));
        return collection;
    }

    @Override
    public <T> Set<T> getSet(String fieldName, SolrDocument document) {
        Collection<T> collection = this.getCollection(fieldName, document);
        if (collection == null) {
            return null;
        }
        return collection instanceof Set ? (Set<Object>)collection : new HashSet<T>(collection);
    }

    @Override
    public <T> List<T> getList(String fieldName, SolrDocument document) {
        Collection<T> collection = this.getCollection(fieldName, document);
        if (collection == null) {
            return null;
        }
        return collection instanceof List ? (List<Object>)collection : new ArrayList<T>(collection);
    }

    static {
        CLASS_SUFFIX_MAPPING.put(String.class, SOLR_TYPE_STRING);
        CLASS_SUFFIX_MAPPING.put(Double.class, SOLR_TYPE_PDOUBLE);
        CLASS_SUFFIX_MAPPING.put(Double.TYPE, SOLR_TYPE_PDOUBLE);
        CLASS_SUFFIX_MAPPING.put(Float.class, SOLR_TYPE_PFLOAT);
        CLASS_SUFFIX_MAPPING.put(Float.TYPE, SOLR_TYPE_PFLOAT);
        CLASS_SUFFIX_MAPPING.put(Long.class, SOLR_TYPE_PLONG);
        CLASS_SUFFIX_MAPPING.put(Long.TYPE, SOLR_TYPE_PLONG);
        CLASS_SUFFIX_MAPPING.put(Integer.class, SOLR_TYPE_PINT);
        CLASS_SUFFIX_MAPPING.put(Integer.TYPE, SOLR_TYPE_PINT);
        CLASS_SUFFIX_MAPPING.put(Boolean.class, SOLR_TYPE_BOOLEAN);
        CLASS_SUFFIX_MAPPING.put(Boolean.TYPE, SOLR_TYPE_BOOLEAN);
        CLASS_SUFFIX_MAPPING.put(Date.class, SOLR_TYPE_PDATE);
        CLASS_SUFFIX_MAPPING.put(byte[].class, SOLR_TYPE_BINARY);
    }
}

