/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.solr.client.solrj.SolrClient;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.search.solr.Solr;
import org.xwiki.search.solr.SolrException;
import org.xwiki.search.solr.XWikiSolrCore;
import org.xwiki.search.solr.internal.api.SolrConfiguration;

@Component
@Singleton
public class DefaultSolr
implements Solr,
Initializable {
    @Inject
    private SolrConfiguration configuration;
    @Inject
    private ComponentManager componentManager;
    private Solr configuredSolr;

    public void initialize() throws InitializationException {
        String type = this.configuration.getServerType();
        try {
            this.configuredSolr = (Solr)this.componentManager.getInstance(Solr.class, type);
        }
        catch (ComponentLookupException e) {
            throw new InitializationException(String.format("Failed to lookup configured Solr type [%s]", type), (Throwable)e);
        }
    }

    @Override
    @Deprecated
    public SolrClient getClient(String name) throws SolrException {
        return this.configuredSolr.getClient(name);
    }

    @Override
    public XWikiSolrCore getCore(String name) throws SolrException {
        return this.configuredSolr.getCore(name);
    }
}

