/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal;

import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.StreamingResponseCallback;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.slf4j.Logger;
import org.xwiki.search.solr.XWikiSolrCore;
import org.xwiki.search.solr.internal.api.SolrInstance;

public abstract class AbstractSolrInstance
implements SolrInstance {
    protected XWikiSolrCore server;
    @Inject
    protected Logger logger;

    @Override
    public void add(SolrInputDocument solrDocument) throws SolrServerException, IOException {
        this.logger.debug("Add Solr document [{}] to index", (Object)solrDocument);
        this.server.getClient().add(solrDocument);
    }

    @Override
    public void add(List<SolrInputDocument> solrDocuments) throws SolrServerException, IOException {
        this.logger.debug("Add Solr documents [{}] to index", solrDocuments);
        this.server.getClient().add(solrDocuments);
    }

    @Override
    public SolrDocument get(String id) throws IOException, SolrServerException {
        return this.server.getClient().getById(id);
    }

    @Override
    public void delete(String id) throws SolrServerException, IOException {
        this.logger.debug("Delete Solr document [{}] from index", (Object)id);
        this.server.getClient().deleteById(id);
    }

    @Override
    public void delete(List<String> ids) throws SolrServerException, IOException {
        this.logger.debug("Delete Solr documents [{}] from index", ids);
        this.server.getClient().deleteById(ids);
    }

    @Override
    public void deleteByQuery(String query) throws SolrServerException, IOException {
        this.logger.debug("Delete Solr documents from index based on query [{}]", (Object)query);
        this.server.getClient().deleteByQuery(query);
    }

    @Override
    public void commit() throws SolrServerException, IOException {
        this.logger.debug("Commit changes to Solr");
        this.server.getClient().commit();
    }

    @Override
    public void rollback() throws SolrServerException, IOException {
        this.logger.debug("Rollback changes to Solr");
        this.server.getClient().rollback();
    }

    @Override
    public QueryResponse query(SolrParams solrParams) throws SolrServerException, IOException {
        this.logger.debug("Execute Solr query [{}]", (Object)solrParams);
        return this.server.getClient().query(solrParams);
    }

    @Override
    public QueryResponse queryAndStreamResponse(SolrParams params, StreamingResponseCallback callback) throws SolrServerException, IOException {
        this.logger.debug("Execute Solr query and stream response [{}]", (Object)params);
        return this.server.getClient().queryAndStreamResponse(params, callback);
    }

    protected SolrClient getServer() {
        return this.server.getClient();
    }
}

