/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.request.schema.FieldTypeDefinition;
import org.apache.solr.client.solrj.response.schema.FieldTypeRepresentation;
import org.slf4j.Logger;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Disposable;
import org.xwiki.search.solr.Solr;
import org.xwiki.search.solr.SolrCoreInitializer;
import org.xwiki.search.solr.SolrException;
import org.xwiki.search.solr.XWikiSolrCore;
import org.xwiki.search.solr.internal.DefaultXWikiSolrCore;
import org.xwiki.search.solr.internal.SolrSchemaUtils;

public abstract class AbstractSolr
implements Solr,
Disposable {
    private static final String SOLR_TYPENAME_SVERSION = "__sversion";
    private static final String SOLR_VERSIONFIELDTYPE_VALUE = "defVal";
    @Inject
    protected ComponentManager componentManager;
    @Inject
    protected SolrSchemaUtils solrSchemaUtils;
    @Inject
    protected Logger logger;
    protected final Map<String, XWikiSolrCore> cores = new ConcurrentHashMap<String, XWikiSolrCore>();

    public void dispose() {
        for (XWikiSolrCore core : this.cores.values()) {
            try {
                core.getClient().close();
            }
            catch (IOException e) {
                this.logger.error("Failed to close Solr client", (Throwable)e);
            }
        }
    }

    @Override
    @Deprecated
    public SolrClient getClient(String name) throws SolrException {
        XWikiSolrCore core = this.getCore(name);
        return core != null ? core.getClient() : null;
    }

    @Override
    public XWikiSolrCore getCore(String name) throws SolrException {
        String id = StringUtils.defaultString((String)name);
        try {
            return this.cores.computeIfAbsent(id, this::getRuntimeCore);
        }
        catch (RuntimeException e) {
            throw new SolrException("Failed to get client", e);
        }
    }

    private XWikiSolrCore getRuntimeCore(String coreName) {
        try {
            return this.getCore(coreName, this.getSolrMajorVersion(), true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private synchronized XWikiSolrCore getCore(String xwikiCoreName, int majorVersion, boolean createAndMigrate) throws SolrServerException, IOException, SolrException {
        String solrCoreName = this.toSolrCoreName(xwikiCoreName, majorVersion);
        SolrClient solrClient = this.getInternalSolrClient(solrCoreName);
        if (this.componentManager.hasComponent(SolrCoreInitializer.class, xwikiCoreName)) {
            SolrCoreInitializer initializer;
            try {
                initializer = (SolrCoreInitializer)this.componentManager.getInstance(SolrCoreInitializer.class, xwikiCoreName);
            }
            catch (ComponentLookupException e) {
                throw new SolrException("Failed to get the SolrCoreInitializer for core name [{}]", (Exception)((Object)e));
            }
            if (solrClient == null && createAndMigrate) {
                solrClient = this.createSolrClient(solrCoreName, initializer.isCache());
            }
            if (solrClient != null) {
                DefaultXWikiSolrCore solrCore = new DefaultXWikiSolrCore(xwikiCoreName, solrCoreName, solrClient);
                if (createAndMigrate) {
                    this.migrateCore(xwikiCoreName, solrCore, initializer);
                    initializer.initialize(solrCore);
                }
                return solrCore;
            }
        } else {
            return new DefaultXWikiSolrCore(xwikiCoreName, solrCoreName, solrClient);
        }
        return null;
    }

    protected void migrateCore(String xwikiCoreName, XWikiSolrCore newCore, SolrCoreInitializer initializer) throws SolrException, SolrServerException, IOException {
        Integer sVersion = this.getSVersion(newCore);
        int solrMajorVersion = this.getSolrMajorVersion();
        if (sVersion == null || sVersion < solrMajorVersion) {
            for (int previousVersion = solrMajorVersion - 1; previousVersion >= 8; --previousVersion) {
                XWikiSolrCore previousCore = this.getCore(xwikiCoreName, previousVersion, false);
                if (previousCore != null) {
                    this.logger.debug("A previous core was found for name [{}] ([{}])", (Object)xwikiCoreName, (Object)previousCore.getSolrName());
                    initializer.migrate(previousCore, newCore);
                    previousCore.getClient().close();
                    break;
                }
                this.logger.debug("Not previous core could be found for name [{}]", (Object)xwikiCoreName);
            }
            this.setSVersion(newCore, solrMajorVersion, sVersion == null);
        }
    }

    protected Integer getSVersion(XWikiSolrCore core) throws SolrException {
        FieldTypeRepresentation fieldType = this.solrSchemaUtils.getFieldTypes(core, false).get(SOLR_TYPENAME_SVERSION);
        if (fieldType == null) {
            return null;
        }
        String value = (String)fieldType.getAttributes().get(SOLR_VERSIONFIELDTYPE_VALUE);
        return NumberUtils.createInteger((String)value);
    }

    protected void setSVersion(XWikiSolrCore core, long version, boolean add) throws SolrException {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("name", SOLR_TYPENAME_SVERSION);
        attributes.put("class", "solr.ExternalFileField");
        attributes.put(SOLR_VERSIONFIELDTYPE_VALUE, String.valueOf(version));
        FieldTypeDefinition definition = new FieldTypeDefinition();
        definition.setAttributes(attributes);
        this.solrSchemaUtils.setFieldType(core, definition, add);
        this.solrSchemaUtils.commit(core);
    }

    protected abstract int getSolrMajorVersion();

    protected String getSolrCoreSuffix() {
        int majorVersion = this.getSolrMajorVersion();
        return this.getSolrCoreSuffix(majorVersion);
    }

    protected String getSolrCoreSuffix(int majorVersion) {
        return majorVersion < 9 ? "" : "_" + this.getSolrMajorVersion();
    }

    protected String toSolrCoreName(String xwikiCoreName) {
        return this.toSolrCoreName(xwikiCoreName, this.getSolrMajorVersion());
    }

    protected String toSolrCoreName(String xwikiCoreName, int majorVersion) {
        return xwikiCoreName + this.getSolrCoreSuffix(majorVersion);
    }

    protected String toXWikiCoreName(String solrCoreName) {
        return StringUtils.removeEnd((String)solrCoreName, (String)this.getSolrCoreSuffix());
    }

    protected abstract SolrClient getInternalSolrClient(String var1) throws SolrException;

    protected abstract SolrClient createSolrClient(String var1, boolean var2) throws SolrException;
}

