/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.lucene.analysis.core.LowerCaseFilterFactory;
import org.apache.lucene.analysis.standard.StandardTokenizerFactory;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.request.schema.AnalyzerDefinition;
import org.apache.solr.client.solrj.request.schema.FieldTypeDefinition;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.schema.FieldTypeRepresentation;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.schema.BinaryField;
import org.apache.solr.schema.BoolField;
import org.apache.solr.schema.DatePointField;
import org.apache.solr.schema.DoublePointField;
import org.apache.solr.schema.FloatPointField;
import org.apache.solr.schema.IntPointField;
import org.apache.solr.schema.LongPointField;
import org.apache.solr.schema.StrField;
import org.apache.solr.schema.TextField;
import org.slf4j.Logger;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.search.solr.SolrCoreInitializer;
import org.xwiki.search.solr.SolrException;
import org.xwiki.search.solr.SolrUtils;
import org.xwiki.search.solr.XWikiSolrCore;
import org.xwiki.search.solr.internal.DefaultSolrUtils;
import org.xwiki.search.solr.internal.DefaultXWikiSolrCore;
import org.xwiki.search.solr.internal.SolrSchemaUtils;
import org.xwiki.stability.Unstable;

public abstract class AbstractSolrCoreInitializer
implements SolrCoreInitializer {
    public static final String SOLR_FIELD_ID = "id";
    public static final long SCHEMA_VERSION_12_3 = 120300000L;
    public static final long SCHEMA_VERSION_12_5 = 120500000L;
    public static final long SCHEMA_VERSION_12_6 = 120600000L;
    public static final long SCHEMA_VERSION_12_9 = 120900000L;
    public static final long SCHEMA_VERSION_12_10 = 121000000L;
    public static final long SCHEMA_VERSION_13_3 = 130300000L;
    public static final long SCHEMA_VERSION_14_0 = 140000000L;
    public static final long SCHEMA_VERSION_14_7 = 140700000L;
    public static final long SCHEMA_VERSION_15_5 = 150500000L;
    public static final long SCHEMA_VERSION_15_6 = 150600000L;
    public static final long SCHEMA_VERSION_15_9 = 150900000L;
    public static final long SCHEMA_VERSION_16_6 = 160600000L;
    public static final long SCHEMA_VERSION_16_7 = 160700000L;
    public static final long SCHEMA_BASE_VERSION = 121000000L;
    protected static final String SOLR_FIELD_NAME = "name";
    protected static final String SOLR_FIELD_INDEXED = "indexed";
    protected static final String SOLR_FIELD_STORED = "stored";
    protected static final String SOLR_FIELD_SORTMISSINGLAST = "sortMissingLast";
    protected static final String SOLR_FIELD_MULTIVALUED = "multiValued";
    protected static final String SOLR_FIELD_DOCVALUES = "docValues";
    private static final String SOLR_TYPENAME_XVERSION = "__xversion";
    private static final int DEFAULT_MIGRATION_BATCH_ROWS = 100;
    @Inject
    protected ComponentDescriptor<SolrCoreInitializer> descriptor;
    @Inject
    protected SolrUtils solrUtils;
    @Inject
    protected Logger logger;
    protected XWikiSolrCore core;
    @Deprecated(since="16.1.0RC1")
    protected SolrClient client;
    @Inject
    private SolrSchemaUtils solrSchemaUtils;

    @Override
    public void initialize(SolrClient client) throws SolrException {
        this.initialize(new DefaultXWikiSolrCore(this.getCoreName(), this.getCoreName(), client));
    }

    @Override
    public void initialize(XWikiSolrCore core) throws SolrException {
        this.core = core;
        this.initializeBaseSchema();
        this.initializeCoreSchema();
        this.commit();
    }

    protected Map<String, FieldTypeRepresentation> getFieldTypes(boolean force) throws SolrException {
        return this.solrSchemaUtils.getFieldTypes(this.core, force);
    }

    protected Map<String, Map<String, Object>> getFields(boolean force) throws SolrException {
        return this.solrSchemaUtils.getFields(this.core, force);
    }

    protected void initializeBaseSchema() throws SolrException {
        Long xversion = this.getCurrentXWikiVersion();
        if (xversion == null) {
            this.createBaseSchema();
            this.setCurrentXWikiVersion(true);
        } else if (xversion < 121000000L) {
            this.migrateBaseSchema(xversion);
            this.setCurrentXWikiVersion(false);
        }
    }

    private void createBaseSchema() throws SolrException {
        this.addFieldType("strings", StrField.class.getName(), SOLR_FIELD_SORTMISSINGLAST, true, SOLR_FIELD_MULTIVALUED, true, SOLR_FIELD_DOCVALUES, true);
        this.addFieldType("boolean", BoolField.class.getName(), SOLR_FIELD_SORTMISSINGLAST, true);
        this.addFieldType("booleans", BoolField.class.getName(), SOLR_FIELD_SORTMISSINGLAST, true, SOLR_FIELD_MULTIVALUED, true);
        this.addFieldType("pint", IntPointField.class.getName(), SOLR_FIELD_DOCVALUES, true);
        this.addFieldType("pfloat", FloatPointField.class.getName(), SOLR_FIELD_DOCVALUES, true);
        this.addFieldType("pdouble", DoublePointField.class.getName(), SOLR_FIELD_DOCVALUES, true);
        this.addFieldType("pints", IntPointField.class.getName(), SOLR_FIELD_DOCVALUES, true, SOLR_FIELD_MULTIVALUED, true);
        this.addFieldType("pfloats", FloatPointField.class.getName(), SOLR_FIELD_DOCVALUES, true, SOLR_FIELD_MULTIVALUED, true);
        this.addFieldType("plongs", LongPointField.class.getName(), SOLR_FIELD_DOCVALUES, true, SOLR_FIELD_MULTIVALUED, true);
        this.addFieldType("pdoubles", DoublePointField.class.getName(), SOLR_FIELD_DOCVALUES, true, SOLR_FIELD_MULTIVALUED, true);
        this.addFieldType("ignored", "solr.StrField", SOLR_FIELD_STORED, false, SOLR_FIELD_INDEXED, false, SOLR_FIELD_MULTIVALUED, true);
        this.addFieldType("pdate", DatePointField.class.getName(), SOLR_FIELD_DOCVALUES, true);
        this.addFieldType("pdates", DatePointField.class.getName(), SOLR_FIELD_DOCVALUES, true, SOLR_FIELD_MULTIVALUED, true);
        this.addFieldType("binary", BinaryField.class.getName(), new Object[0]);
        this.migrateBaseSchema(120300000L);
    }

    private void migrateBaseSchema(long xversion) throws SolrException {
        if (xversion < 121000000L) {
            this.addTextGeneralFieldType("text_general", false);
            this.addTextGeneralFieldType("text_generals", true);
        }
    }

    private void addTextGeneralFieldType(String fieldName, boolean multiValued) throws SolrException {
        HashMap<String, String> tokenizer = new HashMap<String, String>();
        tokenizer.put("class", StandardTokenizerFactory.class.getName());
        HashMap<String, String> lowerCaseFilter = new HashMap<String, String>();
        lowerCaseFilter.put("class", LowerCaseFilterFactory.class.getName());
        AnalyzerDefinition indexAnalyzer = new AnalyzerDefinition();
        indexAnalyzer.setTokenizer(tokenizer);
        indexAnalyzer.setFilters(Arrays.asList(lowerCaseFilter));
        AnalyzerDefinition queryAnalyzer = new AnalyzerDefinition();
        queryAnalyzer.setTokenizer(tokenizer);
        queryAnalyzer.setFilters(Arrays.asList(lowerCaseFilter));
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put(SOLR_FIELD_NAME, fieldName);
        attributes.put("class", TextField.class.getName());
        if (multiValued) {
            attributes.put(SOLR_FIELD_MULTIVALUED, multiValued);
        }
        FieldTypeDefinition definition = new FieldTypeDefinition();
        definition.setAttributes(attributes);
        definition.setIndexAnalyzer(indexAnalyzer);
        definition.setQueryAnalyzer(queryAnalyzer);
        this.setFieldType(definition, true);
    }

    protected void initializeCoreSchema() throws SolrException {
        Long cversion = this.getCurrentCoreVersion();
        if (cversion == null) {
            this.createSchema();
            this.setCurrentCoreVersion(true);
        } else if (cversion < this.getVersion()) {
            this.migrateSchema(cversion);
            this.setCurrentCoreVersion(false);
        }
    }

    protected abstract void createSchema() throws SolrException;

    protected abstract void migrateSchema(long var1) throws SolrException;

    @Override
    public void migrate(XWikiSolrCore sourceCore, XWikiSolrCore targetCore) throws SolrException {
        this.logger.info("Starting migrating Solr core [{}] to [{}]", (Object)sourceCore.getSolrName(), (Object)targetCore.getSolrName());
        this.core = targetCore;
        this.migrateFieldTypes(sourceCore, targetCore);
        this.migrateFields(sourceCore, targetCore);
        this.migrateData(sourceCore, targetCore);
        this.logger.info("Finished migrating Solr core [{}] to [{}]", (Object)sourceCore.getSolrName(), (Object)targetCore.getSolrName());
    }

    private void migrateFieldTypes(XWikiSolrCore sourceCore, XWikiSolrCore targetCore) throws SolrException {
        Map<String, FieldTypeRepresentation> sourceTypes = this.solrSchemaUtils.getFieldTypes(sourceCore, false);
        Map<String, FieldTypeRepresentation> targetTypes = this.solrSchemaUtils.getFieldTypes(targetCore, false);
        this.logger.info("  Migrating [{}] field types from Solr core [{}] to [{}]", new Object[]{sourceTypes.size(), sourceCore.getSolrName(), targetCore.getSolrName()});
        for (Map.Entry<String, FieldTypeRepresentation> entry : sourceTypes.entrySet()) {
            if (targetTypes.containsKey(entry.getKey())) continue;
            this.solrSchemaUtils.setFieldType(targetCore, (FieldTypeDefinition)entry.getValue(), true);
        }
        this.commit(targetCore);
    }

    private void migrateFields(XWikiSolrCore sourceCore, XWikiSolrCore targetCore) throws SolrException {
        this.migrateFields(sourceCore, targetCore, true);
        this.migrateFields(sourceCore, targetCore, false);
        this.migrateCopyFields(sourceCore, targetCore);
        this.commit(targetCore);
    }

    private void migrateFields(XWikiSolrCore sourceCore, XWikiSolrCore targetCore, boolean dynamic) throws SolrException {
        Map<String, Map<String, Object>> sourceFields = dynamic ? this.solrSchemaUtils.getDynamicFields(sourceCore, false) : this.solrSchemaUtils.getFields(sourceCore, false);
        Map<String, Map<String, Object>> targetFields = dynamic ? this.solrSchemaUtils.getDynamicFields(targetCore, false) : this.solrSchemaUtils.getFields(targetCore, false);
        this.logger.info("  Migrating [{}] {} fields from Solr core [{}] to [{}]", new Object[]{sourceFields.size(), dynamic ? " dynamic" : "", sourceCore.getSolrName(), targetCore.getSolrName()});
        for (Map.Entry<String, Map<String, Object>> entry : sourceFields.entrySet()) {
            if (targetFields.containsKey(entry.getKey())) continue;
            this.solrSchemaUtils.setField(targetCore, entry.getValue(), dynamic, true);
        }
    }

    private void migrateCopyFields(XWikiSolrCore sourceCore, XWikiSolrCore targetCore) throws SolrException {
        Map<String, Set<String>> sourceFields = this.solrSchemaUtils.getCopyFields(sourceCore, false);
        Map<String, Set<String>> targetFields = this.solrSchemaUtils.getCopyFields(targetCore, false);
        this.logger.info("Migrating [{}] copy fields from Solr core [{}] to [{}]", new Object[]{sourceFields.size(), sourceCore.getSolrName(), targetCore.getSolrName()});
        for (Map.Entry<String, Set<String>> entry : sourceFields.entrySet()) {
            if (targetFields.containsKey(entry.getKey())) continue;
            this.solrSchemaUtils.addCopyField(targetCore, entry.getKey(), new ArrayList<String>((Collection)entry.getValue()));
        }
    }

    @Unstable
    protected int getMigrationBatchRows() {
        return 100;
    }

    private void migrateData(XWikiSolrCore sourceCore, XWikiSolrCore targetCore) throws SolrException {
        this.logger.info("  Migrating data from Solr core [{}] to [{}]", (Object)sourceCore.getSolrName(), (Object)targetCore.getSolrName());
        int batchSize = this.getMigrationBatchRows();
        long total = -1L;
        int size = 0;
        do {
            QueryResponse response;
            SolrQuery solrQuery = new SolrQuery();
            solrQuery.setRows(Integer.valueOf(batchSize));
            try {
                response = sourceCore.getClient().query((SolrParams)solrQuery);
            }
            catch (Exception e) {
                throw new SolrException("Failed to search for entries in the source client", e);
            }
            SolrDocumentList result = response.getResults();
            size = result.size();
            if (size <= 0) continue;
            if (total == -1L) {
                total = result.getNumFound();
            }
            long remaining = result.getNumFound() - (long)size;
            this.logger.info("    Migrating [{}] documents, [{}] are remaining on a total of [{}] ([{}]% done)", new Object[]{size, remaining, total, Math.round((double)(total - remaining) / (double)total * 100.0)});
            this.migrateData(response.getResults(), sourceCore, targetCore);
        } while (size == batchSize);
    }

    private void migrateData(SolrDocumentList source, XWikiSolrCore sourceCore, XWikiSolrCore targetCore) throws SolrException {
        for (SolrDocument sourceDocument : source) {
            SolrInputDocument targetDocument = new SolrInputDocument();
            this.migrate(sourceDocument, targetDocument);
            try {
                targetCore.getClient().add(targetDocument);
            }
            catch (Exception e) {
                throw new SolrException("Failed to save the document", e);
            }
        }
        this.commit(targetCore);
        this.delete(source, sourceCore);
        this.commit(sourceCore);
    }

    private void delete(SolrDocumentList documents, XWikiSolrCore core) throws SolrException {
        List<String> toDelete = documents.stream().map(this.solrUtils::getId).toList();
        try {
            core.getClient().deleteById(toDelete);
        }
        catch (Exception e) {
            throw new SolrException("Failed to delete the documents", e);
        }
    }

    protected void migrate(SolrDocument sourceDocument, SolrInputDocument targetDocument) {
        for (String fieldName : sourceDocument.getFieldNames()) {
            if (fieldName.equals("_version_")) continue;
            targetDocument.setField(fieldName, sourceDocument.getFieldValue(fieldName));
        }
    }

    @Override
    public String getCoreName() {
        return this.descriptor.getRoleHint();
    }

    protected abstract long getVersion();

    protected Long getCurrentXWikiVersion() throws SolrException {
        return this.getVersion(SOLR_TYPENAME_XVERSION);
    }

    protected void setCurrentXWikiVersion(boolean add) throws SolrException {
        this.setVersion(SOLR_TYPENAME_XVERSION, 121000000L, add);
    }

    protected Long getCurrentCoreVersion() throws SolrException {
        return this.getVersion("__cversion");
    }

    protected void setCurrentCoreVersion(boolean add) throws SolrException {
        this.setVersion("__cversion", this.getVersion(), add);
    }

    private Long getVersion(String name) throws SolrException {
        FieldTypeRepresentation fieldType = this.getFieldType(name);
        if (fieldType == null) {
            return null;
        }
        String value = (String)fieldType.getAttributes().get("defVal");
        return NumberUtils.createLong((String)value);
    }

    private FieldTypeRepresentation getFieldType(String name) throws SolrException {
        return this.getFieldTypes(false).get(name);
    }

    private void setVersion(String name, long version, boolean add) throws SolrException {
        this.setFieldType(name, "solr.ExternalFileField", add, "defVal", String.valueOf(version));
    }

    protected void addStringField(String name, boolean multiValued, boolean dynamic) throws SolrException {
        this.addField(name, multiValued ? "strings" : "string", dynamic, new Object[0]);
    }

    protected void addTextGeneralField(String name, boolean multiValued, boolean dynamic) throws SolrException {
        this.addField(name, multiValued ? "text_generals" : "text_general", dynamic, new Object[0]);
    }

    protected void addBooleanField(String name, boolean multiValued, boolean dynamic) throws SolrException {
        this.addField(name, multiValued ? "booleans" : "boolean", dynamic, new Object[0]);
    }

    protected void addPIntField(String name, boolean multiValued, boolean dynamic) throws SolrException {
        this.addField(name, multiValued ? "pints" : "pint", dynamic, new Object[0]);
    }

    protected void addPFloatField(String name, boolean multiValued, boolean dynamic) throws SolrException {
        this.addField(name, multiValued ? "pfloats" : "pfloat", dynamic, new Object[0]);
    }

    protected void addPLongField(String name, boolean multiValued, boolean dynamic) throws SolrException {
        this.addField(name, multiValued ? "plongs" : "plong", dynamic, new Object[0]);
    }

    protected void addPDoubleField(String name, boolean multiValued, boolean dynamic) throws SolrException {
        this.addField(name, multiValued ? "pdoubles" : "pdouble", dynamic, new Object[0]);
    }

    protected void addPDateField(String name, boolean multiValued, boolean dynamic) throws SolrException {
        this.addField(name, multiValued ? "pdates" : "pdate", dynamic, new Object[0]);
    }

    protected void addBinaryField(String name, boolean dynamic) throws SolrException {
        this.addField(name, "binary", dynamic, new Object[0]);
    }

    protected void addMapField(String name) throws SolrException {
        this.addStringField(DefaultSolrUtils.getMapDynamicFieldName(name, "string"), false, true);
        this.addStringField(DefaultSolrUtils.getMapDynamicFieldName(name, "strings"), true, true);
        this.addBooleanField(DefaultSolrUtils.getMapDynamicFieldName(name, "boolean"), false, true);
        this.addBooleanField(DefaultSolrUtils.getMapDynamicFieldName(name, "booleans"), true, true);
        this.addPIntField(DefaultSolrUtils.getMapDynamicFieldName(name, "pint"), false, true);
        this.addPIntField(DefaultSolrUtils.getMapDynamicFieldName(name, "pints"), true, true);
        this.addPFloatField(DefaultSolrUtils.getMapDynamicFieldName(name, "pfloat"), false, true);
        this.addPFloatField(DefaultSolrUtils.getMapDynamicFieldName(name, "pfloats"), true, true);
        this.addPLongField(DefaultSolrUtils.getMapDynamicFieldName(name, "plong"), false, true);
        this.addPLongField(DefaultSolrUtils.getMapDynamicFieldName(name, "plongs"), true, true);
        this.addPDoubleField(DefaultSolrUtils.getMapDynamicFieldName(name, "pdouble"), false, true);
        this.addPDoubleField(DefaultSolrUtils.getMapDynamicFieldName(name, "pdoubles"), true, true);
        this.addPDateField(DefaultSolrUtils.getMapDynamicFieldName(name, "pdate"), false, true);
        this.addPDateField(DefaultSolrUtils.getMapDynamicFieldName(name, "pdates"), true, true);
        this.addBinaryField(DefaultSolrUtils.getMapDynamicFieldName(name, "binary"), true);
    }

    protected void addField(String name, String type, boolean dynamic, Object ... attributes) throws SolrException {
        this.solrSchemaUtils.setField(this.core, name, type, dynamic, true, attributes);
    }

    protected void addField(Map<String, Object> fieldAttributes, boolean dynamic) throws SolrException {
        this.solrSchemaUtils.setField(this.core, fieldAttributes, dynamic, true);
    }

    protected void deleteField(String fieldName, boolean dynamic) throws SolrException {
        this.solrSchemaUtils.deleteField(this.core, fieldName, dynamic);
    }

    protected void setStringField(String name, boolean multiValued, boolean dynamic, Object ... attributes) throws SolrException {
        this.setField(name, multiValued ? "strings" : "string", dynamic, attributes);
    }

    protected void setTextGeneralField(String name, boolean multiValued, boolean dynamic, Object ... attributes) throws SolrException {
        this.setField(name, multiValued ? "text_generals" : "text_general", dynamic, attributes);
    }

    protected void setBooleanField(String name, boolean multiValued, boolean dynamic, Object ... attributes) throws SolrException {
        this.setField(name, multiValued ? "booleans" : "boolean", dynamic, attributes);
    }

    protected void setPIntField(String name, boolean multiValued, boolean dynamic, Object ... attributes) throws SolrException {
        this.setField(name, multiValued ? "pints" : "pint", dynamic, attributes);
    }

    protected void setPFloatField(String name, boolean multiValued, boolean dynamic, Object ... attributes) throws SolrException {
        this.setField(name, multiValued ? "pfloats" : "pfloat", dynamic, attributes);
    }

    protected void setPLongField(String name, boolean multiValued, boolean dynamic, Object ... attributes) throws SolrException {
        this.setField(name, multiValued ? "plongs" : "plong", dynamic, attributes);
    }

    protected void setPDoubleField(String name, boolean multiValued, boolean dynamic, Object ... attributes) throws SolrException {
        this.setField(name, multiValued ? "pdoubles" : "pdouble", dynamic, attributes);
    }

    protected void setPDateField(String name, boolean multiValued, boolean dynamic, Object ... attributes) throws SolrException {
        this.setField(name, multiValued ? "pdates" : "pdate", dynamic, attributes);
    }

    protected void setBinaryField(String name, boolean dynamic, Object ... attributes) throws SolrException {
        this.setField(name, "binary", dynamic, attributes);
    }

    protected void setMapField(String name, Object ... attributes) throws SolrException {
        this.setStringField(DefaultSolrUtils.getMapDynamicFieldName(name, "string"), false, true, attributes);
        this.setStringField(DefaultSolrUtils.getMapDynamicFieldName(name, "strings"), true, true, attributes);
        this.setBooleanField(DefaultSolrUtils.getMapDynamicFieldName(name, "boolean"), false, true, attributes);
        this.setBooleanField(DefaultSolrUtils.getMapDynamicFieldName(name, "booleans"), true, true, attributes);
        this.setPIntField(DefaultSolrUtils.getMapDynamicFieldName(name, "pint"), false, true, attributes);
        this.setPIntField(DefaultSolrUtils.getMapDynamicFieldName(name, "pints"), true, true, attributes);
        this.setPFloatField(DefaultSolrUtils.getMapDynamicFieldName(name, "pfloat"), false, true, attributes);
        this.setPFloatField(DefaultSolrUtils.getMapDynamicFieldName(name, "pfloats"), true, true, attributes);
        this.setPLongField(DefaultSolrUtils.getMapDynamicFieldName(name, "plong"), false, true, attributes);
        this.setPLongField(DefaultSolrUtils.getMapDynamicFieldName(name, "plongs"), true, true, attributes);
        this.setPDoubleField(DefaultSolrUtils.getMapDynamicFieldName(name, "pdouble"), false, true, attributes);
        this.setPDoubleField(DefaultSolrUtils.getMapDynamicFieldName(name, "pdoubles"), true, true, attributes);
        this.setPDateField(DefaultSolrUtils.getMapDynamicFieldName(name, "pdate"), false, true, attributes);
        this.setPDateField(DefaultSolrUtils.getMapDynamicFieldName(name, "pdates"), true, true, attributes);
        this.setBinaryField(DefaultSolrUtils.getMapDynamicFieldName(name, "binary"), true, attributes);
    }

    protected void setField(String name, String type, boolean dynamic, Object ... attributes) throws SolrException {
        this.solrSchemaUtils.setField(this.core, name, type, dynamic, attributes);
    }

    protected void setField(Map<String, Object> fieldAttributes, boolean dynamic) throws SolrException {
        this.solrSchemaUtils.setField(this.core, fieldAttributes, dynamic);
    }

    protected void addCopyField(String source, String ... dest) throws SolrException {
        this.solrSchemaUtils.addCopyField(this.core, source, dest);
    }

    protected void addFieldType(String name, String solrClass, Object ... attributes) throws SolrException {
        this.setFieldType(name, solrClass, true, attributes);
    }

    protected void replaceFieldType(String name, String solrClass, Object ... attributes) throws SolrException {
        this.setFieldType(name, solrClass, false, attributes);
    }

    protected void setFieldType(String name, String solrClass, boolean add, Object ... attributes) throws SolrException {
        HashMap<String, Object> attributesMap = new HashMap<String, Object>(2 + (attributes.length > 0 ? attributes.length / 2 : 0));
        attributesMap.put(SOLR_FIELD_NAME, name);
        attributesMap.put("class", solrClass);
        MapUtils.putAll(attributesMap, (Object[])attributes);
        this.setFieldType(attributesMap, add);
    }

    protected void setFieldType(Map<String, Object> attributes, boolean add) throws SolrException {
        FieldTypeDefinition definition = new FieldTypeDefinition();
        definition.setAttributes(attributes);
        this.setFieldType(definition, add);
    }

    protected void setFieldType(FieldTypeDefinition definition, boolean add) throws SolrException {
        this.solrSchemaUtils.setFieldType(this.core, definition, add);
    }

    protected void commit() throws SolrException {
        this.solrSchemaUtils.commit(this.core);
    }

    protected void commit(XWikiSolrCore core) throws SolrException {
        try {
            core.getClient().commit();
        }
        catch (Exception e) {
            throw new SolrException("Failed to commit", e);
        }
    }
}

