/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.scheduler;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.api.Object;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseObjectReference;
import com.xpn.xwiki.plugin.PluginApi;
import com.xpn.xwiki.plugin.XWikiPluginInterface;
import com.xpn.xwiki.plugin.scheduler.JobState;
import com.xpn.xwiki.plugin.scheduler.SchedulerPlugin;
import com.xpn.xwiki.plugin.scheduler.SchedulerPluginException;
import java.util.Date;
import java.util.List;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.ObjectReference;
import org.xwiki.stability.Unstable;

public class SchedulerPluginApi
extends PluginApi<SchedulerPlugin> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchedulerPluginApi.class);

    public SchedulerPluginApi(SchedulerPlugin plugin, XWikiContext context) {
        super((XWikiPluginInterface)plugin, context);
    }

    @Unstable
    public boolean isEnabled() {
        return ((SchedulerPlugin)this.getProtectedPlugin()).isEnabled();
    }

    public String getStatus(Object object) {
        try {
            return this.getJobStatus(object.getXWikiObject()).getValue();
        }
        catch (Exception e) {
            this.context.put((java.lang.Object)"error", (java.lang.Object)e.getMessage());
            return null;
        }
    }

    public JobState getJobStatus(BaseObject object) throws SchedulerException {
        return ((SchedulerPlugin)this.getProtectedPlugin()).getJobStatus(object, this.context);
    }

    public JobState getJobStatus(Object object) throws SchedulerException, SchedulerPluginException {
        return ((SchedulerPlugin)this.getProtectedPlugin()).getJobStatus(this.retrieveBaseObject(object), this.context);
    }

    private BaseObject retrieveBaseObject(Object object) throws SchedulerPluginException {
        BaseObjectReference reference = object.getReference();
        try {
            XWikiDocument jobHolder = this.context.getWiki().getDocument((EntityReference)reference, this.context);
            jobHolder = jobHolder.clone();
            return jobHolder.getXObject((ObjectReference)reference);
        }
        catch (XWikiException e) {
            throw new SchedulerPluginException(90010, "Job with reference [" + String.valueOf(reference) + "] could not be retrieved.", e);
        }
    }

    public boolean scheduleJob(Object object) {
        try {
            return this.scheduleJob(this.retrieveBaseObject(object));
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean scheduleJob(BaseObject object) {
        try {
            ((SchedulerPlugin)this.getProtectedPlugin()).scheduleJob(object, this.context);
            return true;
        }
        catch (Exception e) {
            this.context.put((java.lang.Object)"error", (java.lang.Object)e.getMessage());
            return false;
        }
    }

    public boolean scheduleJobs(Document document) {
        boolean result = true;
        try {
            XWikiDocument doc = this.context.getWiki().getDocument(document.getDocumentReference(), this.context);
            doc = doc.clone();
            List objects = doc.getXObjects(SchedulerPlugin.XWIKI_JOB_CLASSREFERENCE);
            for (BaseObject object : objects) {
                result &= this.scheduleJob(object);
            }
        }
        catch (Exception e) {
            this.context.put((java.lang.Object)"error", (java.lang.Object)e.getMessage());
            return false;
        }
        return result;
    }

    public boolean pauseJob(Object object) {
        try {
            return this.pauseJob(this.retrieveBaseObject(object));
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean pauseJob(BaseObject object) {
        try {
            ((SchedulerPlugin)this.getProtectedPlugin()).pauseJob(object, this.context);
            LOGGER.debug("Pause Job: [{}]", (java.lang.Object)object.getStringValue("jobName"));
            return true;
        }
        catch (XWikiException e) {
            this.context.put((java.lang.Object)"error", (java.lang.Object)e.getMessage());
            return false;
        }
    }

    public boolean resumeJob(Object object) {
        try {
            return this.resumeJob(this.retrieveBaseObject(object));
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean resumeJob(BaseObject object) {
        try {
            ((SchedulerPlugin)this.getProtectedPlugin()).resumeJob(object, this.context);
            LOGGER.debug("Resume Job: [{}]", (java.lang.Object)object.getStringValue("jobName"));
            return true;
        }
        catch (XWikiException e) {
            this.context.put((java.lang.Object)"error", (java.lang.Object)e.getMessage());
            return false;
        }
    }

    public boolean unscheduleJob(Object object) {
        try {
            return this.unscheduleJob(this.retrieveBaseObject(object));
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean unscheduleJob(BaseObject object) {
        try {
            ((SchedulerPlugin)this.getProtectedPlugin()).unscheduleJob(object, this.context);
            LOGGER.debug("Delete Job: [{}]", (java.lang.Object)object.getStringValue("jobName"));
            return true;
        }
        catch (XWikiException e) {
            this.context.put((java.lang.Object)"error", (java.lang.Object)e.getMessage());
            return false;
        }
    }

    public boolean triggerJob(Object object) {
        try {
            return this.triggerJob(this.retrieveBaseObject(object));
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean triggerJob(BaseObject object) {
        try {
            ((SchedulerPlugin)this.getProtectedPlugin()).triggerJob(object, this.context);
            LOGGER.debug("Trigger Job: [{}]", (java.lang.Object)object.getStringValue("jobName"));
            return true;
        }
        catch (XWikiException e) {
            this.context.put((java.lang.Object)"error", (java.lang.Object)e.getMessage());
            return false;
        }
    }

    public Date getPreviousFireTime(Object object) {
        try {
            return this.getPreviousFireTime(this.retrieveBaseObject(object));
        }
        catch (Exception e) {
            return null;
        }
    }

    public Date getPreviousFireTime(BaseObject object) {
        try {
            return ((SchedulerPlugin)this.getProtectedPlugin()).getPreviousFireTime(object, this.context);
        }
        catch (SchedulerPluginException e) {
            this.context.put((java.lang.Object)"error", (java.lang.Object)e.getMessage());
            return null;
        }
    }

    public Date getNextFireTime(Object object) {
        try {
            return this.getNextFireTime(this.retrieveBaseObject(object));
        }
        catch (Exception e) {
            return null;
        }
    }

    public Date getNextFireTime(BaseObject object) {
        try {
            return ((SchedulerPlugin)this.getProtectedPlugin()).getNextFireTime(object, this.context);
        }
        catch (SchedulerPluginException e) {
            this.context.put((java.lang.Object)"error", (java.lang.Object)e.getMessage());
            return null;
        }
    }
}

