/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.wikis;

import java.util.List;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.internal.resources.BaseSearchResult;
import org.xwiki.rest.model.jaxb.SearchResults;
import org.xwiki.rest.resources.wikis.WikiSearchResource;

@Component
@Named(value="org.xwiki.rest.internal.resources.wikis.WikiSearchResourceImpl")
public class WikiSearchResourceImpl
extends BaseSearchResult
implements WikiSearchResource {
    public SearchResults search(String wikiName, String keywords, List<String> searchScopeStrings, Integer number, Integer start, String orderField, String order, Boolean withPrettyNames, Boolean isLocaleAware) throws XWikiRestException {
        int limit = this.validateAndGetLimit(number);
        try {
            SearchResults searchResults = this.objectFactory.createSearchResults();
            searchResults.setTemplate(String.format("%s?%s", Utils.createURI(this.uriInfo.getBaseUri(), WikiSearchResource.class, wikiName).toString(), "q={keywords}(&scope={content|name|title|spaces|objects})*(&number={number})(&start={start})(&orderField={fieldname}(&order={asc|desc}))(&prettyNames={false|true})"));
            if (wikiName != null) {
                Utils.getXWikiContext(this.componentManager).setWikiId(wikiName);
            }
            List<BaseSearchResult.SearchScope> searchScopes = this.parseSearchScopeStrings(searchScopeStrings);
            searchResults.getSearchResults().addAll(this.search(searchScopes, keywords, this.getXWikiContext().getWikiId(), null, Utils.getXWiki(this.componentManager).getRightService().hasProgrammingRights(Utils.getXWikiContext(this.componentManager)), limit, start, true, orderField, order, withPrettyNames, isLocaleAware));
            return searchResults;
        }
        catch (Exception e) {
            throw new XWikiRestException((Throwable)e);
        }
    }
}

