/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.wikis;

import com.xpn.xwiki.XWikiContext;
import java.io.InputStream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.xwiki.component.annotation.Component;
import org.xwiki.filter.input.DefaultInputStreamInputSource;
import org.xwiki.filter.input.InputSource;
import org.xwiki.internal.filter.Importer;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.DomainObjectFactory;
import org.xwiki.rest.model.jaxb.Wiki;
import org.xwiki.rest.resources.wikis.WikiResource;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.manager.WikiManagerException;

@Component
@Named(value="org.xwiki.rest.internal.resources.wikis.WikiResourceImpl")
public class WikiResourceImpl
extends XWikiResource
implements WikiResource {
    @Inject
    private Importer importer;
    @Inject
    private WikiDescriptorManager wikis;

    public Wiki get(String wikiName) throws XWikiRestException {
        try {
            if (this.wikis.exists(wikiName)) {
                return DomainObjectFactory.createWiki(this.objectFactory, this.uriInfo.getBaseUri(), wikiName);
            }
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        catch (WikiManagerException e) {
            throw new XWikiRestException((Throwable)e);
        }
    }

    public Wiki importXAR(String wikiName, Boolean backup, String historyStrategy, InputStream is) throws XWikiRestException {
        try {
            if (!this.wikis.exists(wikiName)) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            XWikiContext xwikiContext = this.getXWikiContext();
            WikiReference currentWiki = xwikiContext.getWikiReference();
            try {
                xwikiContext.setWikiId(wikiName);
                DefaultInputStreamInputSource source = new DefaultInputStreamInputSource(is, false);
                this.importer.importXAR((InputSource)source, null, historyStrategy, backup == Boolean.TRUE, this.getXWikiContext());
            }
            catch (Exception e) {
                throw new WebApplicationException("Failed to import the XAR package", (Throwable)e);
            }
            finally {
                xwikiContext.setWikiReference(currentWiki);
            }
            return DomainObjectFactory.createWiki(this.objectFactory, this.uriInfo.getBaseUri(), wikiName);
        }
        catch (WikiManagerException e) {
            throw new XWikiRestException((Throwable)e);
        }
    }
}

