/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.spaces;

import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.api.XWiki;
import java.util.List;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.query.QueryFilter;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.DomainObjectFactory;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.model.jaxb.Spaces;
import org.xwiki.rest.resources.spaces.SpacesResource;

@Component
@Named(value="org.xwiki.rest.internal.resources.spaces.SpacesResourceImpl")
public class SpacesResourceImpl
extends XWikiResource
implements SpacesResource {
    public Spaces getSpaces(String wikiName, Integer start, Integer number) throws XWikiRestException {
        int limit = this.validateAndGetLimit(number);
        Spaces spaces = this.objectFactory.createSpaces();
        try {
            List spaceNames = this.queryManager.getNamedQuery("getSpaces").addFilter((QueryFilter)this.componentManager.getInstance(QueryFilter.class, "hidden")).setOffset(start.intValue()).setLimit(limit).setWiki(wikiName).execute();
            for (String spaceName : spaceNames) {
                List<String> spaceList = Utils.getSpacesFromSpaceId(spaceName);
                String homeId = Utils.getPageId(wikiName, spaceList, "WebHome");
                Document home = null;
                XWiki xwikiApi = Utils.getXWikiApi(this.componentManager);
                if (!xwikiApi.hasAccessLevel("view", homeId)) continue;
                if (xwikiApi.exists(homeId)) {
                    home = Utils.getXWikiApi(this.componentManager).getDocument(homeId);
                }
                spaces.getSpaces().add(DomainObjectFactory.createSpace(this.objectFactory, this.uriInfo.getBaseUri(), wikiName, spaceList, home));
            }
        }
        catch (Exception e) {
            throw new XWikiRestException((Throwable)e);
        }
        return spaces;
    }
}

