/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.pages;

import com.xpn.xwiki.doc.rcs.XWikiRCSNodeId;
import com.xpn.xwiki.internal.store.hibernate.query.HqlQueryUtils;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.query.QueryException;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.DomainObjectFactory;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.model.jaxb.History;
import org.xwiki.rest.model.jaxb.HistorySummary;
import org.xwiki.rest.resources.pages.PageTranslationHistoryResource;
import org.xwiki.security.authorization.AccessDeniedException;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="org.xwiki.rest.internal.resources.pages.PageTranslationHistoryResourceImpl")
public class PageTranslationHistoryResourceImpl
extends XWikiResource
implements PageTranslationHistoryResource {
    @Inject
    private ContextualAuthorizationManager contextualAuthorizationManager;

    public History getPageTranslationHistory(String wikiName, String spaceName, String pageName, String language, Integer start, Integer number, String order, Boolean withPrettyNames) throws XWikiRestException {
        List<String> spaces = this.parseSpaceSegments(spaceName);
        DocumentReference documentReference = new DocumentReference(wikiName, spaces, pageName);
        try {
            this.contextualAuthorizationManager.checkAccess(Right.VIEW, (EntityReference)documentReference);
        }
        catch (AccessDeniedException e) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        String spaceId = Utils.getLocalSpaceId(spaces);
        History history = new History();
        int limit = this.validateAndGetLimit(number);
        try {
            String validOrder = HqlQueryUtils.getValidQueryOrder((String)order, (String)"desc");
            String query = String.format("select doc.space, doc.name, rcs.id, rcs.date, rcs.author, rcs.comment from XWikiRCSNodeInfo as rcs, XWikiDocument as doc where rcs.id.docId = doc.id and doc.space = :space and doc.name = :name and doc.language = :language order by rcs.date %s, rcs.id.version1 %s, rcs.id.version2 %s", validOrder, validOrder, validOrder);
            List queryResult = null;
            queryResult = this.queryManager.createQuery(query, "xwql").bindValue("space", (Object)spaceId).bindValue("name", (Object)pageName).bindValue("language", (Object)language).setLimit(limit).setOffset(start.intValue()).setWiki(wikiName).execute();
            for (Object object : queryResult) {
                Object[] fields = (Object[])object;
                XWikiRCSNodeId nodeId = (XWikiRCSNodeId)fields[2];
                Timestamp timestamp = (Timestamp)fields[3];
                Date modified = new Date(timestamp.getTime());
                String modifier = (String)fields[4];
                String comment = (String)fields[5];
                HistorySummary historySummary = DomainObjectFactory.createHistorySummary(this.objectFactory, this.uriInfo.getBaseUri(), wikiName, spaces, pageName, language, nodeId.getVersion(), modifier, modified, comment, Utils.getXWikiApi(this.componentManager), withPrettyNames);
                history.getHistorySummaries().add(historySummary);
            }
        }
        catch (QueryException e) {
            throw new XWikiRestException((Throwable)e);
        }
        return history;
    }
}

