/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.pages;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.classes.BaseClass;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Named;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.xwiki.component.annotation.Component;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.internal.resources.pages.ModifiablePageResource;
import org.xwiki.rest.model.jaxb.Link;
import org.xwiki.rest.model.jaxb.Tag;
import org.xwiki.rest.model.jaxb.Tags;
import org.xwiki.rest.resources.pages.PageTagsResource;
import org.xwiki.rest.resources.tags.PagesForTagsResource;

@Component
@Named(value="org.xwiki.rest.internal.resources.pages.PageTagsResourceImpl")
public class PageTagsResourceImpl
extends ModifiablePageResource
implements PageTagsResource {
    private static final String PROPERTY_TAGS = "tags";
    private static final String TAG_CLASS = "XWiki.TagClass";

    public Tags getPageTags(String wikiName, String spaceName, String pageName) throws XWikiRestException {
        try {
            String pageId = Utils.getPageId(wikiName, this.parseSpaceSegments(spaceName), pageName);
            List<String> tagNames = this.getTagsFromDocument(pageId);
            Tags tags = this.objectFactory.createTags();
            for (String tagName : tagNames) {
                Tag tag = this.objectFactory.createTag();
                tag.setName(tagName);
                String tagUri = Utils.createURI(this.uriInfo.getBaseUri(), PagesForTagsResource.class, wikiName, tagName).toString();
                Link tagLink = this.objectFactory.createLink();
                tagLink.setHref(tagUri);
                tagLink.setRel("http://www.xwiki.org/rel/tag");
                tag.getLinks().add(tagLink);
                tags.getTags().add(tag);
            }
            return tags;
        }
        catch (XWikiException e) {
            throw new XWikiRestException((Throwable)e);
        }
    }

    public Response setTags(String wikiName, String spaceName, String pageName, Boolean minorRevision, Tags tags) throws XWikiRestException {
        try {
            XWikiResource.DocumentInfo documentInfo = this.getDocumentInfo(wikiName, spaceName, pageName, null, null, true, false);
            Document doc = documentInfo.getDocument();
            if (!doc.hasAccessLevel("edit", Utils.getXWikiUser(this.componentManager))) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            ArrayList<String> tagNames = new ArrayList<String>();
            for (Tag tag : tags.getTags()) {
                tagNames.add(tag.getName());
            }
            XWikiContext xcontext = this.getXWikiContext();
            XWiki xwiki = xcontext.getWiki();
            XWikiDocument xwikiDocument = xwiki.getDocument(doc.getDocumentReference(), xcontext);
            BaseObject xwikiObject = (xwikiDocument = xwikiDocument.clone()).getObject(TAG_CLASS, 0);
            if (xwikiObject == null) {
                int objectNumber = xwikiDocument.createNewObject(TAG_CLASS, xcontext);
                xwikiObject = xwikiDocument.getObject(TAG_CLASS, objectNumber);
                if (xwikiObject == null) {
                    throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
                }
                BaseClass xwikiClass = xwiki.getClass(xwikiObject.getClassName(), xcontext);
                String[] stringArray = xwikiClass.getPropertyNames();
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String propertyNameObject;
                    String propertyName = propertyNameObject = stringArray[i];
                    xwikiObject.set(propertyName, (Object)"", xcontext);
                }
            }
            xwikiObject.set(PROPERTY_TAGS, tagNames, xcontext);
            xwiki.saveDocument(xwikiDocument, "", Boolean.TRUE.equals(minorRevision), this.getXWikiContext());
            return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)tags).build();
        }
        catch (XWikiException e) {
            throw new XWikiRestException((Throwable)e);
        }
    }

    private List<String> getTagsFromDocument(String documentId) throws XWikiException {
        List tags;
        BaseProperty prop;
        XWikiDocument document = Utils.getXWiki(this.componentManager).getDocument(documentId, Utils.getXWikiContext(this.componentManager));
        BaseObject object = document.getObject(TAG_CLASS);
        if (object != null && (prop = (BaseProperty)object.safeget(PROPERTY_TAGS)) != null && (tags = (List)prop.getValue()) != null) {
            return tags;
        }
        return new ArrayList<String>();
    }
}

