/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.pages;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.index.tree.PageHierarchy;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryFilter;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.resources.AbstractPagesResource;
import org.xwiki.rest.model.jaxb.Pages;
import org.xwiki.rest.resources.pages.PageChildrenResource;

@Component
@Named(value="org.xwiki.rest.internal.resources.pages.PageChildrenResourceImpl")
public class PageChildrenResourceImpl
extends AbstractPagesResource
implements PageChildrenResource {
    @Inject
    @Named(value="nestedpages")
    private PageHierarchy nestedPageHierarchy;
    @Inject
    @Named(value="document")
    private QueryFilter documentFilter;

    public Pages getPageChildren(String wikiName, String spaceName, String pageName, Integer start, Integer number, Boolean withPrettyNames, String hierarchy, String search) throws XWikiRestException {
        int limit = this.validateAndGetLimit(number);
        try {
            XWikiResource.DocumentInfo documentInfo = this.getDocumentInfo(wikiName, spaceName, pageName, null, null, true, false);
            if ("nestedpages".equals(hierarchy)) {
                return this.getPages(this.nestedPageHierarchy.getChildren(documentInfo.getDocument().getDocumentReference()).withOffset(start.intValue()).withLimit(limit).matching(search).getDocumentReferences(), withPrettyNames);
            }
            return this.getPages(this.getPageChildrenForParentChildHierarchy(documentInfo, start, limit), withPrettyNames);
        }
        catch (XWikiException | QueryException e) {
            throw new XWikiRestException(e);
        }
    }

    private List<DocumentReference> getPageChildrenForParentChildHierarchy(XWikiResource.DocumentInfo parentInfo, int start, int number) throws QueryException {
        Document parentDocument = parentInfo.getDocument();
        String queryString = "select distinct doc.fullName from XWikiDocument as doc where doc.parent = :parent order by doc.fullName asc";
        return this.queryManager.createQuery(queryString, "xwql").bindValue("parent", (Object)parentDocument.getFullName()).setOffset(start).setLimit(number).addFilter(this.documentFilter).execute();
    }
}

