/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.classes;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.objects.classes.ListItem;
import com.xpn.xwiki.objects.classes.StaticListClass;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.rest.internal.resources.classes.AbstractListClassPropertyValuesProvider;
import org.xwiki.rest.model.jaxb.PropertyValue;
import org.xwiki.rest.model.jaxb.PropertyValues;
import org.xwiki.text.StringUtils;

@Component
@Named(value="StaticList")
@Singleton
public class StaticListClassPropertyValuesProvider
extends AbstractListClassPropertyValuesProvider<StaticListClass> {
    @Override
    protected Class<StaticListClass> getPropertyType() {
        return StaticListClass.class;
    }

    @Override
    protected PropertyValues getAllowedValues(StaticListClass propertyDefinition, int limit, String filter) {
        PropertyValues result = new PropertyValues();
        List allValues = StaticListClass.getListFromString((String)propertyDefinition.getValues());
        Map valueMap = StaticListClass.getMapFromString((String)propertyDefinition.getValues());
        allValues.stream().map(id -> this.addLabelIfDifferent(new PropertyValue(id), propertyDefinition, valueMap)).filter(val -> StringUtils.containsIgnoreCase((CharSequence)val.getValue().toString(), (CharSequence)filter) || val.getMetaData().containsKey("label") && StringUtils.containsIgnoreCase((CharSequence)val.getMetaData().get("label").toString(), (CharSequence)filter)).limit(limit).forEach(xva$0 -> result.withPropertyValues(new PropertyValue[]{xva$0}));
        return result;
    }

    @Override
    protected PropertyValue getValueFromQueryResult(Object result, StaticListClass propertyDefinition) {
        PropertyValue value = super.getValueFromQueryResult(result, propertyDefinition);
        if (value != null && value.getValue() instanceof String) {
            Map valueMap = StaticListClass.getMapFromString((String)propertyDefinition.getValues());
            this.addLabelIfDifferent(value, propertyDefinition, valueMap);
        }
        return value;
    }

    private PropertyValue addLabelIfDifferent(PropertyValue value, StaticListClass propertyDefinition, Map<String, ListItem> map) {
        String displayValue;
        String id = (String)value.getValue();
        if (!id.equals(displayValue = propertyDefinition.getDisplayValue(id, propertyDefinition.getName(), map, (XWikiContext)this.xcontextProvider.get()))) {
            value.getMetaData().put("label", displayValue);
        }
        return value;
    }
}

