/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.classes;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Class;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.ModelFactory;
import org.xwiki.rest.internal.RangeIterable;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.model.jaxb.Classes;
import org.xwiki.rest.resources.classes.ClassesResource;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="org.xwiki.rest.internal.resources.classes.ClassesResourceImpl")
public class ClassesResourceImpl
extends XWikiResource
implements ClassesResource {
    @Inject
    private ModelFactory utils;
    @Inject
    @Named(value="currentmixed")
    private DocumentReferenceResolver<String> resolver;
    @Inject
    private ContextualAuthorizationManager authorization;

    public Classes getClasses(String wikiName, Integer start, Integer number) throws XWikiRestException {
        int limit = this.validateAndGetLimit(number);
        String database = Utils.getXWikiContext(this.componentManager).getWikiId();
        try {
            this.getXWikiContext().setWikiId(wikiName);
            List classNames = Utils.getXWikiApi(this.componentManager).getClassList();
            Collections.sort(classNames);
            RangeIterable ri = new RangeIterable(classNames, start, limit);
            Classes classes = this.objectFactory.createClasses();
            for (String className : ri) {
                DocumentReference classReference = this.resolver.resolve((Object)className, new Object[]{new WikiReference(wikiName)});
                if (!this.authorization.hasAccess(Right.VIEW, (EntityReference)classReference)) continue;
                Class xwikiClass = Utils.getXWikiApi(this.componentManager).getClass((EntityReference)classReference);
                classes.getClazzs().add(this.utils.toRestClass(this.uriInfo.getBaseUri(), xwikiClass));
            }
            Classes classes2 = classes;
            return classes2;
        }
        catch (XWikiException e) {
            throw new XWikiRestException((Throwable)e);
        }
        finally {
            Utils.getXWikiContext(this.componentManager).setWikiId(database);
        }
    }
}

