/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.classes;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Class;
import java.util.Iterator;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.DomainObjectFactory;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.model.jaxb.Link;
import org.xwiki.rest.model.jaxb.Property;
import org.xwiki.rest.resources.classes.ClassPropertyResource;
import org.xwiki.rest.resources.classes.ClassResource;
import org.xwiki.security.authorization.AccessDeniedException;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="org.xwiki.rest.internal.resources.classes.ClassPropertyResourceImpl")
public class ClassPropertyResourceImpl
extends XWikiResource
implements ClassPropertyResource {
    @Inject
    @Named(value="currentmixed")
    private DocumentReferenceResolver<String> resolver;
    @Inject
    private ContextualAuthorizationManager authorization;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Property getClassProperty(String wikiName, String className, String propertyName) throws XWikiRestException {
        String database = Utils.getXWikiContext(this.componentManager).getWikiId();
        try {
            Utils.getXWikiContext(this.componentManager).setWikiId(wikiName);
            DocumentReference classReference = this.resolver.resolve((Object)className, new Object[]{new WikiReference(wikiName)});
            this.authorization.checkAccess(Right.VIEW, (EntityReference)classReference);
            Class xwikiClass = Utils.getXWikiApi(this.componentManager).getClass((EntityReference)classReference);
            if (xwikiClass == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            org.xwiki.rest.model.jaxb.Class clazz = DomainObjectFactory.createClass(this.objectFactory, this.uriInfo.getBaseUri(), wikiName, xwikiClass);
            Iterator iterator = clazz.getProperties().iterator();
            while (iterator.hasNext()) {
                Property property = (Property)iterator.next();
                if (property.getName().equals(propertyName)) {
                    String classUri = Utils.createURI(this.uriInfo.getBaseUri(), ClassResource.class, wikiName, xwikiClass.getName()).toString();
                    Link classLink = this.objectFactory.createLink();
                    classLink.setHref(classUri);
                    classLink.setRel("http://www.xwiki.org/rel/class");
                    property.getLinks().add(classLink);
                    Property property2 = property;
                    return property2;
                }
            }
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        catch (XWikiException e) {
            throw new XWikiRestException((Throwable)e);
        }
        catch (AccessDeniedException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.UNAUTHORIZED);
        }
        finally {
            Utils.getXWikiContext(this.componentManager).setWikiId(database);
        }
    }
}

