/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.classes;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Class;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.DomainObjectFactory;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.model.jaxb.Link;
import org.xwiki.rest.model.jaxb.Properties;
import org.xwiki.rest.resources.classes.ClassPropertiesResource;
import org.xwiki.rest.resources.classes.ClassResource;
import org.xwiki.security.authorization.AccessDeniedException;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="org.xwiki.rest.internal.resources.classes.ClassPropertiesResourceImpl")
public class ClassPropertiesResourceImpl
extends XWikiResource
implements ClassPropertiesResource {
    @Inject
    @Named(value="currentmixed")
    private DocumentReferenceResolver<String> resolver;
    @Inject
    private ContextualAuthorizationManager authorization;

    public Properties getClassProperties(String wikiName, String className) throws XWikiRestException {
        String database = Utils.getXWikiContext(this.componentManager).getWikiId();
        try {
            Utils.getXWikiContext(this.componentManager).setWikiId(wikiName);
            DocumentReference classReference = this.resolver.resolve((Object)className, new Object[]{new WikiReference(wikiName)});
            this.authorization.checkAccess(Right.VIEW, (EntityReference)classReference);
            Class xwikiClass = Utils.getXWikiApi(this.componentManager).getClass((EntityReference)classReference);
            if (xwikiClass == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            org.xwiki.rest.model.jaxb.Class clazz = DomainObjectFactory.createClass(this.objectFactory, this.uriInfo.getBaseUri(), wikiName, xwikiClass);
            Properties properties = this.objectFactory.createProperties();
            properties.getProperties().addAll(clazz.getProperties());
            String classUri = Utils.createURI(this.uriInfo.getBaseUri(), ClassResource.class, wikiName, xwikiClass.getName()).toString();
            Link classLink = this.objectFactory.createLink();
            classLink.setHref(classUri);
            classLink.setRel("http://www.xwiki.org/rel/class");
            properties.getLinks().add(classLink);
            Properties properties2 = properties;
            return properties2;
        }
        catch (XWikiException e) {
            throw new XWikiRestException((Throwable)e);
        }
        catch (AccessDeniedException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.UNAUTHORIZED);
        }
        finally {
            Utils.getXWikiContext(this.componentManager).setWikiId(database);
        }
    }
}

