/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.classes;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.objects.PropertyInterface;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.xwiki.model.reference.ClassPropertyReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryFilter;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.model.jaxb.PropertyValue;
import org.xwiki.rest.model.jaxb.PropertyValues;
import org.xwiki.rest.resources.classes.ClassPropertyValuesProvider;
import org.xwiki.text.StringUtils;

public abstract class AbstractClassPropertyValuesProvider<T>
implements ClassPropertyValuesProvider {
    protected static final String META_DATA_LABEL = "label";
    protected static final String META_DATA_COUNT = "count";
    protected static final String META_DATA_ICON = "icon";
    protected static final String META_DATA_HINT = "hint";
    protected static final String META_DATA_URL = "url";
    protected static final String TEXT_FILTER = "text";
    @Inject
    protected Provider<XWikiContext> xcontextProvider;
    @Inject
    protected EntityReferenceSerializer<String> entityReferenceSerializer;
    @Inject
    @Named(value="text")
    private QueryFilter textFilter;

    public PropertyValues getValues(ClassPropertyReference propertyReference, int limit, Object ... filterParameters) throws XWikiRestException {
        T propertyDefinition = this.getPropertyDefinition(propertyReference);
        String filter = "";
        if (filterParameters.length > 0 && filterParameters[0] != null) {
            filter = filterParameters[0].toString();
        }
        try {
            if (filter.isEmpty() || limit <= 0) {
                return this.getAllowedValues(propertyDefinition, limit, filter);
            }
            return this.getMixedValues(propertyDefinition, limit, filter);
        }
        catch (Exception e) {
            throw new XWikiRestException((Throwable)e);
        }
    }

    public PropertyValue getValue(ClassPropertyReference propertyReference, Object rawValue) throws XWikiRestException {
        return this.getValueFromQueryResult(rawValue, this.getPropertyDefinition(propertyReference));
    }

    protected T getPropertyDefinition(ClassPropertyReference propertyReference) throws XWikiRestException {
        try {
            XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
            PropertyInterface property = xcontext.getWiki().getDocument((EntityReference)propertyReference, xcontext).getXClass().get(propertyReference.getName());
            if (property == null) {
                throw new XWikiRestException(String.format("Property [%s] not found.", this.entityReferenceSerializer.serialize((EntityReference)propertyReference, new Object[0])));
            }
            if (this.getPropertyType().isInstance(property)) {
                return (T)property;
            }
            throw new XWikiRestException(String.format("This [%s] is not a [%s] property.", this.entityReferenceSerializer.serialize((EntityReference)propertyReference, new Object[0]), this.getPropertyType().getSimpleName()));
        }
        catch (XWikiException e) {
            throw new XWikiRestException((Throwable)e);
        }
    }

    protected abstract Class<T> getPropertyType();

    protected PropertyValues getValues(Query query, int limit, String filter, T propertyDefinition) throws QueryException {
        if (limit > 0) {
            query.setLimit(limit);
        }
        if (!StringUtils.isEmpty((CharSequence)filter)) {
            query.addFilter(this.textFilter);
            query.bindValue(TEXT_FILTER).anyChars().literal(filter).anyChars();
        }
        return this.getValuesFromQueryResults(query.execute(), propertyDefinition);
    }

    protected PropertyValue getValue(Query query, String filter, T propertyDefinition) throws QueryException {
        List result;
        PropertyValue propertyValue = null;
        if (!StringUtils.isEmpty((CharSequence)filter)) {
            query.addFilter(this.textFilter);
            query.bindValue(TEXT_FILTER).literal(filter);
        }
        if (!(result = query.execute()).isEmpty()) {
            propertyValue = this.getValueFromQueryResult(result.get(0), propertyDefinition);
        }
        return propertyValue;
    }

    protected abstract PropertyValues getAllowedValues(T var1, int var2, String var3) throws Exception;

    protected PropertyValues getValuesFromQueryResults(List<Object> results, T propertyDefinition) {
        PropertyValues values = new PropertyValues();
        for (Object result : results) {
            PropertyValue value = this.getValueFromQueryResult(result, propertyDefinition);
            if (value == null) continue;
            values.getPropertyValues().add(value);
        }
        return values;
    }

    protected PropertyValue getValueFromQueryResult(Object result, T propertyDefinition) {
        PropertyValue value = null;
        if (result instanceof Object[]) {
            Object[] row = (Object[])result;
            if (row.length > 0 && row[0] != null) {
                value = new PropertyValue(row[0]);
                if (row.length > 1 && row[1] != null) {
                    value.getMetaData().put(this.getMetaDataType(row[1]), row[1]);
                }
            }
        } else if (result != null) {
            value = new PropertyValue(result);
        }
        return value;
    }

    protected String getMetaDataType(Object value) {
        return value instanceof Long ? META_DATA_COUNT : META_DATA_LABEL;
    }

    protected abstract PropertyValues getUsedValues(T var1, int var2, String var3) throws QueryException;

    private PropertyValues getMixedValues(T propertyDefinition, int limit, String filter) throws Exception {
        PropertyValues values = this.getAllowedValues(propertyDefinition, limit, filter);
        if (values.getPropertyValues().size() < limit) {
            PropertyValues usedValues = this.getUsedValues(propertyDefinition, limit - values.getPropertyValues().size(), filter);
            for (PropertyValue usedValue : usedValues.getPropertyValues()) {
                if (values.getPropertyValues().size() >= limit) break;
                this.maybeAddUsedValue(values, usedValue);
            }
        }
        return values;
    }

    private void maybeAddUsedValue(PropertyValues values, PropertyValue usedValue) {
        PropertyValue value = this.findValue(values, usedValue.getValue());
        if (value == null) {
            values.getPropertyValues().add(usedValue);
        } else {
            this.mergeMetaData(value, usedValue);
        }
    }

    private PropertyValue findValue(PropertyValues values, Object data) {
        for (PropertyValue value : values.getPropertyValues()) {
            if (!Objects.equals(value.getValue(), data)) continue;
            return value;
        }
        return null;
    }

    private void mergeMetaData(PropertyValue alice, PropertyValue bob) {
        bob.getMetaData().forEach((key, value) -> alice.getMetaData().putIfAbsent(key, value));
    }
}

