/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.attachments;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Attachment;
import com.xpn.xwiki.api.Document;
import java.io.ByteArrayInputStream;
import java.net.URI;
import javax.inject.Named;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.xwiki.attachment.validation.AttachmentValidationException;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.resources.BaseAttachmentsResource;
import org.xwiki.rest.resources.attachments.AttachmentResource;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="org.xwiki.rest.internal.resources.attachments.AttachmentResourceImpl")
public class AttachmentResourceImpl
extends BaseAttachmentsResource
implements AttachmentResource {
    public Response getAttachment(String wikiName, String spaceName, String pageName, String attachmentName) throws XWikiRestException {
        try {
            XWikiResource.DocumentInfo documentInfo = this.getDocumentInfo(wikiName, spaceName, pageName, null, null, true, false);
            Document doc = documentInfo.getDocument();
            Attachment xwikiAttachment = doc.getAttachment(attachmentName);
            if (xwikiAttachment == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            return Response.ok().type(xwikiAttachment.getMimeType()).entity((Object)xwikiAttachment.getContent()).build();
        }
        catch (XWikiException e) {
            throw new XWikiRestException((Throwable)e);
        }
    }

    public Response putAttachment(String wikiName, String spaceName, String pageName, String attachmentName, byte[] content) throws XWikiRestException, AttachmentValidationException {
        try {
            XWikiResource.DocumentInfo documentInfo = this.getDocumentInfo(wikiName, spaceName, pageName, null, null, true, true);
            Document doc = documentInfo.getDocument();
            if (!this.authorization.hasAccess(Right.EDIT, (EntityReference)doc.getDocumentReference())) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            ByteArrayInputStream inputStream = new ByteArrayInputStream(content != null ? content : new byte[]{});
            BaseAttachmentsResource.AttachmentInfo attachmentInfo = this.storeAndRetrieveAttachment(doc, attachmentName, inputStream, false);
            if (attachmentInfo.isAlreadyExisting()) {
                return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)attachmentInfo.getAttachment()).build();
            }
            return Response.created((URI)this.uriInfo.getAbsolutePath()).entity((Object)attachmentInfo.getAttachment()).build();
        }
        catch (XWikiException e) {
            throw new XWikiRestException((Throwable)e);
        }
    }

    public void deleteAttachment(String wikiName, String spaceName, String pageName, String attachmentName) throws XWikiRestException {
        try {
            XWikiResource.DocumentInfo documentInfo = this.getDocumentInfo(wikiName, spaceName, pageName, null, null, true, true);
            Document doc = documentInfo.getDocument();
            if (!this.authorization.hasAccess(Right.EDIT, (EntityReference)doc.getDocumentReference())) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            Attachment xwikiAttachment = doc.removeAttachment(attachmentName);
            if (xwikiAttachment == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            doc.save("Deleted attachment [" + attachmentName + "]");
        }
        catch (XWikiException e) {
            throw new XWikiRestException((Throwable)e);
        }
    }
}

