/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources;

import com.xpn.xwiki.doc.rcs.XWikiRCSNodeId;
import com.xpn.xwiki.internal.store.hibernate.query.HqlQueryUtils;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.query.QueryException;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.DomainObjectFactory;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.model.jaxb.History;
import org.xwiki.rest.model.jaxb.HistorySummary;
import org.xwiki.rest.resources.ModificationsResource;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="org.xwiki.rest.internal.resources.ModificationsResourceImpl")
public class ModificationsResourceImpl
extends XWikiResource
implements ModificationsResource {
    @Inject
    private ContextualAuthorizationManager authorizationManager;
    @Inject
    private DocumentReferenceResolver<String> resolver;

    public History getModifications(String wikiName, Integer start, Integer number, String order, Long ts, Boolean withPrettyNames) throws XWikiRestException {
        int limit = this.validateAndGetLimit(number);
        try {
            String validOrder = HqlQueryUtils.getValidQueryOrder((String)order, (String)"desc");
            History history = new History();
            String query = String.format("select doc.space, doc.name, doc.language, rcs.id, rcs.date, rcs.author, rcs.comment from XWikiRCSNodeInfo as rcs, XWikiDocument as doc where rcs.id.docId = doc.id and rcs.date > :date order by rcs.date %s, rcs.id.version1 %s, rcs.id.version2 %s", validOrder, validOrder, validOrder);
            List queryResult = null;
            queryResult = this.queryManager.createQuery(query, "xwql").bindValue("date", (Object)new Date(ts)).setLimit(limit).setOffset(start.intValue()).setWiki(wikiName).execute();
            for (Object object : queryResult) {
                String pageName;
                Object[] fields = (Object[])object;
                String spaceId = (String)fields[0];
                List<String> spaces = Utils.getSpacesFromSpaceId(spaceId);
                DocumentReference documentReference = this.resolver.resolve((Object)Utils.getPageId(wikiName, spaces, pageName = (String)fields[1]), new Object[0]);
                if (!this.authorizationManager.hasAccess(Right.VIEW, (EntityReference)documentReference)) continue;
                String language = (String)fields[2];
                if (language.equals("")) {
                    language = null;
                }
                XWikiRCSNodeId nodeId = (XWikiRCSNodeId)fields[3];
                Timestamp timestamp = (Timestamp)fields[4];
                Date modified = new Date(timestamp.getTime());
                String modifier = (String)fields[5];
                String comment = (String)fields[6];
                HistorySummary historySummary = DomainObjectFactory.createHistorySummary(this.objectFactory, this.uriInfo.getBaseUri(), wikiName, spaces, pageName, language, nodeId.getVersion(), modifier, modified, comment, Utils.getXWikiApi(this.componentManager), withPrettyNames);
                history.getHistorySummaries().add(historySummary);
            }
            return history;
        }
        catch (QueryException e) {
            throw new XWikiRestException((Throwable)e);
        }
    }
}

