/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.api.XWiki;
import com.xpn.xwiki.internal.store.hibernate.query.HqlQueryUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Formatter;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.ws.rs.core.UriBuilderException;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.localization.LocalizationContext;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceProvider;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryFilter;
import org.xwiki.query.QueryManager;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.internal.ModelFactory;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.internal.resources.search.SearchSource;
import org.xwiki.rest.model.jaxb.Link;
import org.xwiki.rest.model.jaxb.SearchResult;
import org.xwiki.rest.resources.objects.ObjectResource;
import org.xwiki.rest.resources.pages.PageResource;
import org.xwiki.rest.resources.pages.PageTranslationResource;
import org.xwiki.rest.resources.spaces.SpaceResource;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

public class BaseSearchResult
extends XWikiResource {
    protected static final String SEARCH_TEMPLATE_INFO = "q={keywords}(&scope={content|name|title|spaces|objects})*(&number={number})(&start={start})(&orderField={fieldname}(&order={asc|desc}))(&prettyNames={false|true})";
    protected static final String QUERY_TEMPLATE_INFO = "q={query}(&type={type})(&number={number})(&start={start})(&orderField={fieldname}(&order={asc|desc}))(&distinct=1)(&prettyNames={false|true})(&wikis={wikis})(&className={classname})";
    @Inject
    private ContextualAuthorizationManager authorizationManager;
    @Inject
    @Named(value="hidden/space")
    private Provider<QueryFilter> hiddenSpaceFilterProvider;
    @Inject
    private LocalizationContext localizationContext;
    @Inject
    private ModelFactory modelFactory;
    @Inject
    private EntityReferenceProvider defaultEntityReferenceProvider;
    @Inject
    @Named(value="secure")
    private QueryManager secureQueryManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<SearchResult> search(List<SearchScope> searchScopes, String keywords, String wikiName, String space, boolean hasProgrammingRights, int number, int start, boolean distinct, String orderField, String order, Boolean withPrettyNames, Boolean isLocaleAware) throws IllegalArgumentException, UriBuilderException, QueryException, XWikiException {
        String database = Utils.getXWikiContext(this.componentManager).getWikiId();
        try {
            if (wikiName != null) {
                Utils.getXWikiContext(this.componentManager).setWikiId(wikiName);
            }
            ArrayList<SearchResult> result = new ArrayList<SearchResult>();
            result.addAll(this.searchPages(searchScopes, keywords, wikiName, space, hasProgrammingRights, number, start, orderField, order, withPrettyNames, isLocaleAware));
            if (searchScopes.contains((Object)SearchScope.SPACES)) {
                result.addAll(this.searchSpaces(keywords, wikiName, number, start));
            }
            if (searchScopes.contains((Object)SearchScope.OBJECTS)) {
                result.addAll(this.searchObjects(keywords, wikiName, space, hasProgrammingRights, number, start, orderField, order, withPrettyNames));
            }
            ArrayList<SearchResult> arrayList = result;
            return arrayList;
        }
        finally {
            Utils.getXWikiContext(this.componentManager).setWikiId(database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<SearchResult> searchPages(List<SearchScope> searchScopes, String keywords, String wikiName, String space, boolean hasProgrammingRights, int number, int start, String orderField, String order, Boolean withPrettyNames, Boolean isLocaleAware) throws QueryException, IllegalArgumentException, UriBuilderException, XWikiException {
        String database = Utils.getXWikiContext(this.componentManager).getWikiId();
        try {
            String orderClause;
            if (keywords == null) {
                ArrayList<SearchResult> arrayList = new ArrayList<SearchResult>();
                return arrayList;
            }
            QueryManager finalQueryManager = this.queryManager;
            Formatter f = new Formatter();
            String addColumn = "";
            if (!StringUtils.isBlank((CharSequence)orderField)) {
                addColumn = orderField.equals("") || orderField.equals("fullName") || orderField.equals("name") || orderField.equals("space") ? "" : ", doc." + orderField;
            }
            String addSpace = "";
            if (searchScopes.contains((Object)SearchScope.NAME)) {
                addSpace = "left join XWikiSpace as space on doc.space = space.reference";
            }
            if (space != null) {
                f.format("select distinct doc.fullName, doc.space, doc.name, doc.language", new Object[0]);
                f.format(addColumn, new Object[0]);
                f.format(" from XWikiDocument as doc %s where doc.space = :space and ( ", addSpace);
            } else {
                f.format("select distinct doc.fullName, doc.space, doc.name, doc.language", new Object[0]);
                f.format(addColumn, new Object[0]);
                f.format(" from XWikiDocument as doc %s where ( ", addSpace);
            }
            int acceptedScopes = 0;
            for (int i = 0; i < searchScopes.size(); ++i) {
                SearchScope scope = searchScopes.get(i);
                switch (scope) {
                    case CONTENT: {
                        f.format("upper(doc.content) like :keywords ", new Object[0]);
                        ++acceptedScopes;
                        break;
                    }
                    case NAME: {
                        String matchTerminalPage = "doc.name <> :defaultDocName and upper(doc.name) like :keywords";
                        String matchNestedPage = "doc.name = :defaultDocName and upper(space.name) like :keywords";
                        f.format("((%s) or (%s)) ", matchTerminalPage, matchNestedPage);
                        ++acceptedScopes;
                        break;
                    }
                    case TITLE: {
                        f.format("(upper(doc.title) like :keywords", new Object[0]);
                        if (isLocaleAware.booleanValue()) {
                            f.format(" and (", new Object[0]);
                            String emptyLanguageCondition = "(doc.language = '' or doc.language is null)";
                            f.format("(doc.language = :locale or (%s and doc.defaultLanguage = :locale)) ", emptyLanguageCondition);
                            f.format("or (doc.language = :language or (%s and doc.defaultLanguage = :language)) ", emptyLanguageCondition);
                            f.format("or (%s and not exists( from XWikiDocument as doc2 where doc2.fullName = doc.fullName and (doc2.language = :locale or doc2.language = :language))))", emptyLanguageCondition);
                        }
                        f.format(") ", new Object[0]);
                        ++acceptedScopes;
                    }
                }
                if (i == searchScopes.size() - 1) continue;
                f.format(" or ", new Object[0]);
            }
            if (acceptedScopes == 0) {
                ArrayList<SearchResult> i = new ArrayList<SearchResult>();
                return i;
            }
            if (StringUtils.isBlank((CharSequence)orderField)) {
                orderClause = "doc.fullName asc";
            } else {
                orderClause = String.format("doc.%s %s", orderField, HqlQueryUtils.getValidQueryOrder((String)order, (String)"asc"));
                if (!StringUtils.isAlphanumeric((CharSequence)orderField)) {
                    finalQueryManager = this.secureQueryManager;
                }
            }
            f.format(") order by %s", orderClause);
            String queryString = f.toString();
            Query query = finalQueryManager.createQuery(queryString, "hql").bindValue("keywords", (Object)String.format("%%%s%%", keywords.toUpperCase())).addFilter(Utils.getHiddenQueryFilter(this.componentManager)).setOffset(start).setLimit(number * 2);
            if (space != null) {
                query.bindValue("space", (Object)space);
            }
            if (searchScopes.contains((Object)SearchScope.NAME)) {
                query.bindValue("defaultDocName", (Object)this.defaultEntityReferenceProvider.getDefaultReference(EntityType.DOCUMENT).getName());
            }
            if (isLocaleAware.booleanValue() && searchScopes.contains((Object)SearchScope.TITLE)) {
                Locale userLocale = this.localizationContext.getCurrentLocale();
                query.bindValue("locale", (Object)userLocale.toString());
                query.bindValue("language", (Object)userLocale.getLanguage());
            }
            List<SearchResult> list = this.getPagesSearchResults(query.execute(), wikiName, withPrettyNames, number, isLocaleAware);
            return list;
        }
        finally {
            Utils.getXWikiContext(this.componentManager).setWikiId(database);
        }
    }

    protected List<SearchResult> getPagesSearchResults(List<Object> queryResult, String wikiName, Boolean withPrettyNames, int limit, Boolean withUniquePages) throws XWikiException {
        ArrayList<SearchResult> result = new ArrayList<SearchResult>();
        HashSet<String> seenPages = new HashSet<String>();
        XWiki xwikiApi = Utils.getXWikiApi(this.componentManager);
        for (Object object : queryResult) {
            String pageUri;
            if (limit > 0 && result.size() >= limit) break;
            Object[] fields = (Object[])object;
            String spaceId = (String)fields[1];
            List<String> spaces = Utils.getSpacesFromSpaceId(spaceId);
            String pageName = (String)fields[2];
            String language = (String)fields[3];
            String pageId = Utils.getPageId(wikiName, spaces, pageName);
            String pageFullName = Utils.getPageFullName(wikiName, spaces, pageName);
            if (withUniquePages.booleanValue() && seenPages.contains(pageFullName)) continue;
            seenPages.add(pageFullName);
            if (!xwikiApi.hasAccessLevel("view", pageId)) continue;
            Document doc = xwikiApi.getDocument(pageFullName).getTranslatedDocument();
            String title = doc.getDisplayTitle();
            SearchResult searchResult = this.objectFactory.createSearchResult();
            searchResult.setType("page");
            searchResult.setId(pageId);
            searchResult.setPageFullName(pageFullName);
            searchResult.setTitle(title);
            searchResult.setWiki(wikiName);
            searchResult.setSpace(spaceId);
            searchResult.setPageName(pageName);
            searchResult.setVersion(doc.getVersion());
            searchResult.setAuthor(doc.getAuthor());
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(doc.getDate());
            searchResult.setModified(calendar);
            if (withPrettyNames.booleanValue()) {
                searchResult.setAuthorName(Utils.getAuthorName(doc.getAuthorReference(), this.componentManager));
            }
            if (StringUtils.isBlank((CharSequence)language)) {
                pageUri = Utils.createURI(this.uriInfo.getBaseUri(), PageResource.class, wikiName, Utils.getSpacesURLElements(spaces), pageName).toString();
            } else {
                searchResult.setLanguage(language);
                pageUri = Utils.createURI(this.uriInfo.getBaseUri(), PageTranslationResource.class, wikiName, Utils.getSpacesURLElements(spaces), pageName, language).toString();
            }
            Link pageLink = new Link();
            pageLink.setHref(pageUri);
            pageLink.setRel("http://www.xwiki.org/rel/page");
            searchResult.getLinks().add(pageLink);
            searchResult.setHierarchy(this.modelFactory.toRestHierarchy((EntityReference)doc.getDocumentReference(), withPrettyNames));
            result.add(searchResult);
        }
        return result;
    }

    protected List<SearchResult> searchSpaces(String keywords, String wikiName, int number, int start) throws QueryException, IllegalArgumentException, UriBuilderException, XWikiException {
        ArrayList<SearchResult> result = new ArrayList<SearchResult>();
        if (StringUtils.isEmpty((CharSequence)keywords)) {
            return result;
        }
        String escapedKeywords = keywords.replaceAll("([%_!])", "!$1");
        String query = "select space.reference from XWikiSpace as space where lower(space.name) like lower(:keywords) escape '!' or lower(space.reference) like lower(:prefix) escape '!' order by lower(space.reference), space.reference";
        List queryResult = this.queryManager.createQuery(query, "hql").bindValue("keywords", (Object)String.format("%%%s%%", escapedKeywords)).bindValue("prefix", (Object)String.format("%s%%", escapedKeywords)).setWiki(wikiName).setLimit(number).setOffset(start).addFilter((QueryFilter)this.hiddenSpaceFilterProvider.get()).execute();
        XWiki xwikiApi = Utils.getXWikiApi(this.componentManager);
        for (Object object : queryResult) {
            String spaceId = (String)object;
            List<String> spaces = Utils.getSpacesFromSpaceId(spaceId);
            SpaceReference spaceReference = new SpaceReference(wikiName, spaces);
            if (!this.authorizationManager.hasAccess(Right.VIEW, (EntityReference)spaceReference)) continue;
            Document spaceDoc = xwikiApi.getDocument((EntityReference)spaceReference);
            SearchResult searchResult = this.objectFactory.createSearchResult();
            searchResult.setType("space");
            searchResult.setId(spaceId);
            searchResult.setWiki(wikiName);
            searchResult.setSpace(spaceId);
            searchResult.setTitle(spaceDoc != null ? spaceDoc.getPlainTitle() : spaceReference.getName());
            List<String> restSpacesValue = Utils.getSpacesURLElements(spaces);
            Link spaceLink = new Link();
            spaceLink.setRel("http://www.xwiki.org/rel/space");
            spaceLink.setHref(Utils.createURI(this.uriInfo.getBaseUri(), SpaceResource.class, wikiName, restSpacesValue).toString());
            searchResult.getLinks().add(spaceLink);
            if (spaceDoc != null && !spaceDoc.isNew()) {
                Link pageLink = new Link();
                pageLink.setHref(Utils.createURI(this.uriInfo.getBaseUri(), PageResource.class, wikiName, restSpacesValue, spaceDoc.getDocumentReference().getName()).toString());
                pageLink.setRel("http://www.xwiki.org/rel/home");
                searchResult.getLinks().add(pageLink);
            }
            result.add(searchResult);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<SearchResult> searchObjects(String keywords, String wikiName, String space, boolean hasProgrammingRights, int number, int start, String orderField, String order, Boolean withPrettyNames) throws QueryException, IllegalArgumentException, UriBuilderException, XWikiException {
        XWikiContext xwikiContext = Utils.getXWikiContext(this.componentManager);
        XWiki xwikiApi = Utils.getXWikiApi(this.componentManager);
        String database = Utils.getXWikiContext(this.componentManager).getWikiId();
        try {
            String addColumn;
            ArrayList<SearchResult> result = new ArrayList<SearchResult>();
            if (keywords == null) {
                ArrayList<SearchResult> arrayList = result;
                return arrayList;
            }
            QueryManager finalQueryManager = this.queryManager;
            Formatter f = new Formatter();
            String string = addColumn = orderField.equals("") || orderField.equals("fullName") || orderField.equals("name") || orderField.equals("space") ? "" : ", doc." + orderField;
            if (space != null) {
                f.format("select distinct doc.fullName, doc.space, doc.name, obj.className, obj.number", new Object[0]);
                f.format(addColumn, new Object[0]);
                f.format(" from XWikiDocument as doc, BaseObject as obj, StringProperty as sp, LargeStringProperty as lsp where doc.space = :space and obj.name=doc.fullName and sp.id.id = obj.id and lsp.id.id = obj.id and (upper(sp.value) like :keywords or upper(lsp.value) like :keywords) ", new Object[0]);
            } else {
                f.format("select distinct doc.fullName, doc.space, doc.name, obj.className, obj.number", new Object[0]);
                f.format(addColumn, new Object[0]);
                f.format(" from XWikiDocument as doc, BaseObject as obj, StringProperty as sp, LargeStringProperty as lsp where obj.name=doc.fullName and sp.id.id = obj.id and lsp.id.id = obj.id and (upper(sp.value) like :keywords or upper(lsp.value) like :keywords) ", new Object[0]);
            }
            String orderClause = null;
            if (StringUtils.isBlank((CharSequence)orderField)) {
                orderClause = "doc.fullName asc";
            } else {
                orderClause = String.format("doc.%s %s", orderField, HqlQueryUtils.getValidQueryOrder((String)order, (String)"asc"));
                if (!StringUtils.isAlphanumeric((CharSequence)orderField)) {
                    finalQueryManager = this.secureQueryManager;
                }
            }
            if (hasProgrammingRights) {
                f.format(" order by %s", orderClause);
            } else {
                f.format(" and doc.space<>'XWiki' and doc.space<>'Admin' and doc.space<>'Panels' and doc.name<>'WebPreferences' order by %s", orderClause);
            }
            String query = f.toString();
            List queryResult = null;
            queryResult = space != null ? finalQueryManager.createQuery(query, "xwql").bindValue("keywords", (Object)String.format("%%%s%%", keywords.toUpperCase())).bindValue("space", (Object)space).setLimit(number).execute() : finalQueryManager.createQuery(query, "xwql").bindValue("keywords", (Object)String.format("%%%s%%", keywords.toUpperCase())).setLimit(number).execute();
            for (Object object : queryResult) {
                Object[] fields = (Object[])object;
                String spaceId = (String)fields[1];
                List<String> spaces = Utils.getSpacesFromSpaceId(spaceId);
                String pageName = (String)fields[2];
                String className = (String)fields[3];
                int objectNumber = (Integer)fields[4];
                String id = Utils.getObjectId(wikiName, spaces, pageName, className, objectNumber);
                String pageId = Utils.getPageId(wikiName, spaces, pageName);
                String pageFullName = Utils.getPageFullName(wikiName, spaces, pageName);
                if (!xwikiApi.hasAccessLevel("view", pageId) || xwikiContext.getUserReference() == null) continue;
                Document doc = xwikiApi.getDocument(pageFullName);
                String title = doc.getDisplayTitle();
                SearchResult searchResult = this.objectFactory.createSearchResult();
                searchResult.setType("object");
                searchResult.setId(id);
                searchResult.setPageFullName(pageFullName);
                searchResult.setTitle(title);
                searchResult.setWiki(wikiName);
                searchResult.setSpace(spaceId);
                searchResult.setPageName(pageName);
                searchResult.setVersion(doc.getVersion());
                searchResult.setClassName(className);
                searchResult.setObjectNumber(Integer.valueOf(objectNumber));
                searchResult.setAuthor(doc.getAuthor());
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(doc.getDate());
                searchResult.setModified(calendar);
                if (withPrettyNames.booleanValue()) {
                    searchResult.setAuthorName(Utils.getAuthorName(doc.getAuthorReference(), this.componentManager));
                }
                List<String> restSpacesValue = Utils.getSpacesURLElements(spaces);
                String pageUri = Utils.createURI(this.uriInfo.getBaseUri(), PageResource.class, wikiName, restSpacesValue, pageName).toString();
                Link pageLink = new Link();
                pageLink.setHref(pageUri);
                pageLink.setRel("http://www.xwiki.org/rel/page");
                searchResult.getLinks().add(pageLink);
                String objectUri = Utils.createURI(this.uriInfo.getBaseUri(), ObjectResource.class, wikiName, restSpacesValue, pageName, className, objectNumber).toString();
                Link objectLink = new Link();
                objectLink.setHref(objectUri);
                objectLink.setRel("http://www.xwiki.org/rel/object");
                searchResult.getLinks().add(objectLink);
                result.add(searchResult);
            }
            ArrayList<SearchResult> arrayList = result;
            return arrayList;
        }
        finally {
            Utils.getXWikiContext(this.componentManager).setWikiId(database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<SearchResult> searchQuery(String query, String queryTypeString, String wikiName, String wikis, boolean hasProgrammingRights, String orderField, String order, boolean distinct, int number, int start, Boolean withPrettyNames, String className) throws Exception {
        String currentWiki = Utils.getXWikiContext(this.componentManager).getWikiId();
        try {
            List<SearchResult> result;
            if (wikiName != null) {
                Utils.getXWikiContext(this.componentManager).setWikiId(wikiName);
            }
            if (queryTypeString != null) {
                SearchSource searchSource = (SearchSource)this.componentManager.getInstance(SearchSource.class, queryTypeString.toLowerCase());
                result = searchSource.search(query, wikiName, wikis, hasProgrammingRights, orderField, order, distinct, number, start, withPrettyNames, className, this.uriInfo);
            } else {
                result = new ArrayList<SearchResult>();
            }
            ArrayList<SearchResult> arrayList = result;
            return arrayList;
        }
        finally {
            Utils.getXWikiContext(this.componentManager).setWikiId(currentWiki);
        }
    }

    protected List<SearchScope> parseSearchScopeStrings(List<String> searchScopeStrings) {
        ArrayList<SearchScope> searchScopes = new ArrayList<SearchScope>();
        for (String searchScopeString : searchScopeStrings) {
            if (searchScopeString == null || searchScopes.contains(searchScopeString)) continue;
            try {
                SearchScope searchScope = SearchScope.valueOf(searchScopeString.toUpperCase());
                searchScopes.add(searchScope);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        if (searchScopes.isEmpty()) {
            searchScopes.add(SearchScope.CONTENT);
        }
        return searchScopes;
    }

    protected static enum SearchScope {
        SPACES,
        NAME,
        CONTENT,
        TITLE,
        OBJECTS;

    }
}

