/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.api.Document;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.internal.ModelFactory;
import org.xwiki.rest.model.jaxb.PageSummary;
import org.xwiki.rest.model.jaxb.Pages;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

public abstract class AbstractPagesResource
extends XWikiResource {
    @Inject
    protected ModelFactory modelFactory;
    @Inject
    protected ContextualAuthorizationManager contextualAuthorizationManager;

    protected Pages getPages(List<DocumentReference> documentReferences, boolean withPrettyNames) {
        return this.objectFactory.createPages().withPageSummaries((Collection)documentReferences.stream().filter(documentReference -> this.contextualAuthorizationManager.hasAccess(Right.VIEW, (EntityReference)documentReference)).map(documentReference -> this.getPageSummary((DocumentReference)documentReference, withPrettyNames)).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    protected PageSummary getPageSummary(DocumentReference documentReference, boolean withPrettyNames) {
        try {
            XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
            Document document = xcontext.getWiki().getDocument(documentReference, xcontext).newDocument(xcontext);
            return this.modelFactory.toRestPageSummary(this.uriInfo.getBaseUri(), document, withPrettyNames);
        }
        catch (Exception e) {
            this.getLogger().warn("Failed to get document [{}]. Root cause is [{}].", (Object)documentReference, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return null;
        }
    }
}

