/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.representations.tags;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.xwiki.component.annotation.Component;
import org.xwiki.rest.JAXRSUtils;
import org.xwiki.rest.XWikiRestComponent;
import org.xwiki.rest.model.jaxb.ObjectFactory;
import org.xwiki.rest.model.jaxb.Tag;
import org.xwiki.rest.model.jaxb.Tags;

@Component
@Named(value="org.xwiki.rest.internal.representations.tags.FormUrlEncodedTagsReader")
@Provider
@Consumes(value={"application/x-www-form-urlencoded"})
@Singleton
public class FormUrlEncodedTagsReader
implements MessageBodyReader<Tags>,
XWikiRestComponent {
    private static final String TAGS_FIELD_NAME = "tags";
    private static final String TAG_FIELD_NAME = "tag";
    private static final Pattern TAG_SEPARATORS = Pattern.compile(" |,|\\|");
    @Inject
    private JAXRSUtils jaxrs;

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Tags.class.isAssignableFrom(type);
    }

    public Tags readFrom(Class<Tags> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        Object tagNames;
        MultivaluedMap<String, String> form = this.jaxrs.readForm(mediaType, annotations, entityStream);
        ObjectFactory objectFactory = new ObjectFactory();
        Tags tags = objectFactory.createTags();
        String text = (String)form.getFirst((Object)TAGS_FIELD_NAME);
        if (text != null) {
            for (Object tagName : tagNames = TAG_SEPARATORS.split(text)) {
                Tag tag = objectFactory.createTag();
                tag.setName((String)tagName);
                tags.getTags().add(tag);
            }
        }
        if ((tagNames = (List)form.get((Object)TAG_FIELD_NAME)) != null) {
            Iterator iterator = tagNames.iterator();
            while (iterator.hasNext()) {
                String tagName = (String)iterator.next();
                Tag tag = objectFactory.createTag();
                tag.setName(tagName);
                tags.getTags().add(tag);
            }
        }
        return tags;
    }
}

