/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.representations.objects;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.xwiki.component.annotation.Component;
import org.xwiki.rest.JAXRSUtils;
import org.xwiki.rest.XWikiRestComponent;
import org.xwiki.rest.model.jaxb.Object;
import org.xwiki.rest.model.jaxb.ObjectFactory;
import org.xwiki.rest.model.jaxb.Property;

@Component
@Named(value="org.xwiki.rest.internal.representations.objects.FormUrlEncodedObjectReader")
@Provider
@Consumes(value={"application/x-www-form-urlencoded"})
@Singleton
public class FormUrlEncodedObjectReader
implements MessageBodyReader<Object>,
XWikiRestComponent {
    private static final String CLASSNAME_FIELD_NAME = "className";
    private static final String PROPERTY_PREFIX = "property#";
    @Inject
    private JAXRSUtils jaxrs;

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Object.class.isAssignableFrom(type);
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        MultivaluedMap<String, String> form = this.jaxrs.readForm(mediaType, annotations, entityStream);
        ObjectFactory objectFactory = new ObjectFactory();
        Object object = objectFactory.createObject();
        object.setClassName((String)form.getFirst((java.lang.Object)CLASSNAME_FIELD_NAME));
        for (String name : form.keySet()) {
            if (!name.startsWith(PROPERTY_PREFIX)) continue;
            Property property = objectFactory.createProperty();
            property.setName(name.replace(PROPERTY_PREFIX, ""));
            property.setValue((String)form.getFirst((java.lang.Object)name));
            object.getProperties().add(property);
        }
        return object;
    }
}

