/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.exceptions;

import com.xpn.xwiki.XWikiException;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.query.QueryException;
import org.xwiki.rest.XWikiRestComponent;
import org.xwiki.rest.XWikiRestException;

@Component
@Named(value="org.xwiki.rest.internal.exceptions.XWikiRestExceptionMapper")
@Provider
@Singleton
public class XWikiRestExceptionMapper
implements ExceptionMapper<XWikiRestException>,
XWikiRestComponent {
    public Response toResponse(XWikiRestException exception) {
        Throwable cause = exception.getCause();
        if (cause instanceof XWikiException) {
            XWikiException xwikiException = (XWikiException)cause;
            if (xwikiException.getCode() == 9001) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)exception.getMessage()).type(MediaType.TEXT_PLAIN_TYPE).build();
            }
        } else if (cause instanceof QueryException) {
            QueryException queryException = (QueryException)cause;
            return Response.serverError().entity((Object)String.format("%s\n%s\n", exception.getMessage(), ExceptionUtils.getRootCauseMessage((Throwable)queryException))).type(MediaType.TEXT_PLAIN_TYPE).build();
        }
        return Response.serverError().entity((Object)exception.getMessage()).type(MediaType.TEXT_PLAIN_TYPE).build();
    }
}

