/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.csrf.CSRFToken;
import org.xwiki.rest.XWikiRestComponent;

@Component
@Named(value="org.xwiki.rest.internal.PreMatchingRequestFilter")
@Singleton
@Provider
@PreMatching
public class PreMatchingRequestFilter
implements ContainerRequestFilter,
XWikiRestComponent {
    private static final List<String> SIMPLE_CONTENT_TYPES = List.of("application/x-www-form-urlencoded", "multipart/form-data", "text/plain");
    private static final String FORM_TOKEN_HEADER = "XWiki-Form-Token";
    private static final String ACCEPT_HEADER = "Accept";
    private static final Map<String, MediaType> ACCEPT_MAPPING = new HashMap<String, MediaType>();
    @Inject
    private CSRFToken csrfToken;
    @Inject
    private Logger logger;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String mediaOverride;
        if ("POST".equals(requestContext.getMethod())) {
            String methodOverride;
            String formToken;
            if (SIMPLE_CONTENT_TYPES.stream().anyMatch(expectedType -> requestContext.getMediaType() != null && Strings.CI.startsWith((CharSequence)requestContext.getMediaType().toString(), (CharSequence)expectedType)) && !this.csrfToken.isTokenValid(formToken = (String)requestContext.getHeaders().getFirst((Object)FORM_TOKEN_HEADER))) {
                requestContext.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"Invalid or missing form token.").type("text/plain").build());
            }
            if (StringUtils.isNotEmpty((CharSequence)(methodOverride = (String)requestContext.getUriInfo().getQueryParameters().getFirst((Object)"method")))) {
                requestContext.setMethod(methodOverride);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(mediaOverride = (String)requestContext.getUriInfo().getQueryParameters().getFirst((Object)"media")))) {
            MediaType mediaType = ACCEPT_MAPPING.get(mediaOverride);
            if (mediaType == null) {
                try {
                    mediaType = MediaType.valueOf((String)mediaOverride);
                }
                catch (IllegalArgumentException e) {
                    this.logger.warn("Bad media type value [{}] provided: {}", (Object)mediaOverride, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                }
            }
            if (mediaType != null) {
                requestContext.getHeaders().remove((Object)ACCEPT_HEADER);
                requestContext.getHeaders().add((Object)ACCEPT_HEADER, (Object)mediaType.toString());
            }
        }
    }

    static {
        ACCEPT_MAPPING.put("atom", MediaType.APPLICATION_ATOM_XML_TYPE);
        ACCEPT_MAPPING.put("bin", MediaType.APPLICATION_OCTET_STREAM_TYPE);
        ACCEPT_MAPPING.put("exe", MediaType.APPLICATION_OCTET_STREAM_TYPE);
        ACCEPT_MAPPING.put("form", MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        ACCEPT_MAPPING.put("java", MediaType.TEXT_PLAIN_TYPE);
        ACCEPT_MAPPING.put("jsf", MediaType.TEXT_PLAIN_TYPE);
        ACCEPT_MAPPING.put("nt", MediaType.TEXT_PLAIN_TYPE);
        ACCEPT_MAPPING.put("htm", MediaType.TEXT_HTML_TYPE);
        ACCEPT_MAPPING.put("html", MediaType.TEXT_HTML_TYPE);
        ACCEPT_MAPPING.put("json", MediaType.APPLICATION_JSON_TYPE);
        ACCEPT_MAPPING.put("txt", MediaType.TEXT_PLAIN_TYPE);
        ACCEPT_MAPPING.put("xhtml", MediaType.APPLICATION_XHTML_XML_TYPE);
        ACCEPT_MAPPING.put("xml", MediaType.APPLICATION_XML_TYPE);
    }
}

