/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.StringTokenizer;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Encoded;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.io.IOUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.container.Container;
import org.xwiki.container.Request;
import org.xwiki.container.servlet.ServletRequest;
import org.xwiki.rest.JAXRSUtils;

@Component
@Singleton
public class DefaultJAXRSUtils
implements JAXRSUtils {
    @Inject
    private Container container;

    @Override
    public Charset getCharset(MediaType mediaType) {
        String name;
        if (mediaType != null && (name = (String)mediaType.getParameters().get("charset")) != null) {
            return Charset.forName(name);
        }
        return StandardCharsets.UTF_8;
    }

    private boolean decode(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (annotation.annotationType() != Encoded.class) continue;
            return false;
        }
        return true;
    }

    @Override
    public MultivaluedMap<String, String> readForm(MediaType mediaType, Annotation[] annotations, InputStream entityStream) throws IOException {
        MultivaluedHashMap map = new MultivaluedHashMap();
        boolean decode = this.decode(annotations);
        Charset charset = this.getCharset(mediaType);
        String encoded = IOUtils.toString((InputStream)entityStream, (Charset)charset);
        if (encoded.isEmpty()) {
            this.readFormFromEntity((MultivaluedMap<String, String>)map);
        } else {
            this.readFormFromEntity(encoded, decode, charset, (MultivaluedMap<String, String>)map);
        }
        return map;
    }

    private void readFormFromEntity(MultivaluedMap<String, String> map) {
        Request request = this.container.getRequest();
        if (request instanceof ServletRequest) {
            ServletRequest servletRequest = (ServletRequest)request;
            HttpServletRequest httpRequest = servletRequest.getHttpServletRequest();
            httpRequest.getParameterMap().forEach((k, v) -> map.put(k, Arrays.asList(v)));
        }
    }

    private void readFormFromEntity(String encoded, boolean decode, Charset charset, MultivaluedMap<String, String> map) {
        StringTokenizer tokenizer = new StringTokenizer(encoded, "&");
        try {
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                int idx = token.indexOf(61);
                if (idx < 0) {
                    map.add((Object)(decode ? URLDecoder.decode(token, charset) : token), null);
                    continue;
                }
                if (idx <= 0) continue;
                if (decode) {
                    map.add((Object)URLDecoder.decode(token.substring(0, idx), charset), (Object)URLDecoder.decode(token.substring(idx + 1), charset));
                    continue;
                }
                map.add((Object)token.substring(0, idx), (Object)token.substring(idx + 1));
            }
        }
        catch (IllegalArgumentException ex) {
            throw new BadRequestException((Throwable)ex);
        }
    }
}

