/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.localization.LocaleUtils;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.query.QueryManager;
import org.xwiki.rest.XWikiRestComponent;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.model.jaxb.ObjectFactory;
import org.xwiki.security.SecurityConfiguration;
import org.xwiki.stability.Unstable;

@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class XWikiResource
implements XWikiRestComponent,
Initializable {
    @Context
    protected UriInfo uriInfo;
    @Inject
    protected Logger slf4Jlogger;
    protected ObjectFactory objectFactory;
    @Inject
    @Named(value="context")
    protected ComponentManager componentManager;
    @Inject
    protected Provider<XWikiContext> xcontextProvider;
    @Inject
    protected QueryManager queryManager;
    @Inject
    private SecurityConfiguration securityConfiguration;

    @Unstable
    protected int validateAndGetLimit(Integer limit) {
        int configuredLimit = this.securityConfiguration.getQueryItemsLimit();
        if (limit == null) {
            return configuredLimit;
        }
        if (configuredLimit >= 0 && (limit < 0 || limit > configuredLimit)) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid limit value: %s. The limit must be a positive integer and less than or equal to %s.".formatted(limit, configuredLimit)).type("text/plain").build());
        }
        return limit;
    }

    public void initialize() throws InitializationException {
        this.objectFactory = new ObjectFactory();
        this.slf4Jlogger.trace("Resource {} initialized. Serving user: '{}'\n", (Object)this.getClass().getName(), (Object)((XWikiContext)this.xcontextProvider.get()).getUserReference());
    }

    public List<String> parseSpaceSegments(String spaceSegments) throws XWikiRestException {
        ArrayList<String> spaces = new ArrayList<String>();
        int i = 1;
        for (String space : spaceSegments.split("/")) {
            if (i++ % 2 == 0) {
                if ("spaces".equals(space)) continue;
                throw new XWikiRestException("Malformed URL: the spaces section is invalid.");
            }
            if (!space.isEmpty()) {
                try {
                    spaces.add(URLDecoder.decode(space, "UTF-8"));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new XWikiRestException("Unable to decode space name.", (Throwable)e);
                }
            }
            throw new XWikiRestException("Malformed URL: a space name cannot be empty.");
        }
        return spaces;
    }

    public SpaceReference getSpaceReference(String spaceSegments, String wikiName) throws XWikiRestException {
        return Utils.getSpaceReference(this.parseSpaceSegments(spaceSegments), wikiName);
    }

    public DocumentInfo getDocumentInfo(String wikiName, String spaceName, String pageName, String language, String version, boolean failIfDoesntExist, boolean failIfLocked) throws XWikiException, XWikiRestException {
        return this.getDocumentInfo(wikiName, this.parseSpaceSegments(spaceName), pageName, language, version, failIfDoesntExist, failIfLocked);
    }

    public DocumentInfo getDocumentInfo(String wikiName, List<String> spaces, String pageName, String localeString, String version, boolean failIfDoesntExist, boolean failIfLocked) throws XWikiException {
        Locale locale;
        if (wikiName == null || spaces == null || spaces.isEmpty() || pageName == null) {
            throw new IllegalArgumentException(String.format("wikiName, spaceName and pageName must all be not null. Current values: (%s:%s.%s)", wikiName, spaces, pageName));
        }
        if (localeString != null) {
            try {
                locale = LocaleUtils.toLocale((String)localeString);
            }
            catch (Exception e) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
        } else {
            locale = null;
        }
        DocumentReference reference = new DocumentReference(wikiName, spaces, pageName, locale);
        Document doc = Utils.getXWikiApi(this.componentManager).getDocument(reference);
        if (doc == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        if (failIfDoesntExist && doc.isNew()) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        if (version != null && (doc = doc.getDocumentRevision(version)) == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        if (failIfLocked && doc.getLocked()) {
            throw new WebApplicationException(Response.Status.PRECONDITION_FAILED);
        }
        return new DocumentInfo(doc, doc.isNew());
    }

    protected XWikiContext getXWikiContext() {
        return (XWikiContext)this.xcontextProvider.get();
    }

    protected Logger getLogger() {
        return this.slf4Jlogger;
    }

    protected static class DocumentInfo {
        private Document document;
        private boolean created;

        public DocumentInfo(Document document, boolean created) {
            this.document = document;
            this.created = created;
        }

        public Document getDocument() {
            return this.document;
        }

        public boolean isCreated() {
            return this.created;
        }
    }
}

