/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.jersey.internal;

import javax.annotation.Priority;
import org.glassfish.jersey.inject.hk2.Hk2InjectionManagerFactory;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.InjectionManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rest.jersey.internal.XWikiInjectionManager;

@Priority(value=100)
public class XWikiInjectionManagerFactory
implements InjectionManagerFactory {
    protected static final Logger LOGGER = LoggerFactory.getLogger(XWikiInjectionManagerFactory.class);

    public InjectionManager create(Object parent) {
        InjectionManager injectionManager;
        if (parent instanceof ComponentManager) {
            ComponentManager componentManager = (ComponentManager)parent;
            try {
                injectionManager = (InjectionManager)componentManager.getInstance(XWikiInjectionManager.class);
            }
            catch (ComponentLookupException e) {
                throw new RuntimeException("Failed to lookup XWikiInjectionManager", e);
            }
        } else {
            injectionManager = new Hk2InjectionManagerFactory().create(parent);
        }
        return injectionManager;
    }
}

