/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.jersey.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.glassfish.jersey.inject.hk2.Hk2InjectionManagerFactory;
import org.glassfish.jersey.internal.inject.Binder;
import org.glassfish.jersey.internal.inject.Binding;
import org.glassfish.jersey.internal.inject.ForeignDescriptor;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.ServiceHolder;
import org.glassfish.jersey.server.internal.process.RequestProcessingContext;
import org.glassfish.jersey.server.internal.process.RequestProcessingContextReference;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.rest.XWikiRestComponent;

@Component(roles={XWikiInjectionManager.class})
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class XWikiInjectionManager
implements InjectionManager,
Initializable {
    private static final Set<Class<?>> CONTEXT_REQUEST = Set.of(HttpHeaders.class, Request.class, ContainerRequestContext.class);
    private static final Set<Class<?>> CONTEXT_ROUTING = Set.of(UriInfo.class, ResourceInfo.class);
    private static final Set<Class<?>> CONTEXT_ASYNC = Set.of(AsyncResponse.class);
    private static final Set<Class<?>> CONTEXT_SECURITY = Set.of(SecurityContext.class);
    @Inject
    @Named(value="context")
    private ComponentManager componentManager;
    @Inject
    private Logger logger;
    private InjectionManager injectionManager;

    public void initialize() {
        Hk2InjectionManagerFactory factory = new Hk2InjectionManagerFactory();
        this.injectionManager = factory.create();
    }

    public <T> T getInstance(Class<T> contractOrImpl) {
        if (XWikiRestComponent.class.isAssignableFrom(contractOrImpl) && this.componentManager.hasComponent(XWikiRestComponent.class, contractOrImpl.getName())) {
            try {
                Object component = this.componentManager.getInstance(XWikiRestComponent.class, contractOrImpl.getName());
                this.injectJAXRS(component);
                return (T)component;
            }
            catch (ComponentLookupException e) {
                this.logger.error("Failed to lookup the component [{}]", (Object)contractOrImpl.getName(), (Object)e);
            }
        }
        return (T)this.injectionManager.getInstance(contractOrImpl);
    }

    private RequestProcessingContext getRequestProcessingContext() {
        return ((RequestProcessingContextReference)this.injectionManager.getInstance(RequestProcessingContextReference.class)).get();
    }

    private ContainerRequestContext getContainerRequestContext() {
        return (ContainerRequestContext)this.injectionManager.getInstance(ContainerRequestContext.class);
    }

    private void injectJAXRS(Object component) {
        for (Field field : FieldUtils.getFieldsListWithAnnotation(component.getClass(), Context.class)) {
            try {
                Object value = CONTEXT_REQUEST.contains(field.getType()) ? this.getRequestProcessingContext().request() : (CONTEXT_ROUTING.contains(field.getType()) ? this.getRequestProcessingContext().routingContext() : (CONTEXT_ASYNC.contains(field.getType()) ? this.getRequestProcessingContext().asyncContext() : (CONTEXT_SECURITY.contains(field.getType()) ? this.getContainerRequestContext().getSecurityContext() : this.injectionManager.getInstance(field.getType()))));
                FieldUtils.writeField((Field)field, (Object)component, (Object)value, (boolean)true);
            }
            catch (IllegalAccessException e) {
                this.logger.error("Failed to inject JAX-RS fields in component [{}]", component.getClass(), (Object)e);
            }
        }
    }

    public <T> T getInstance(Class<T> contractOrImpl, Annotation ... qualifiers) {
        return (T)this.injectionManager.getInstance(contractOrImpl, qualifiers);
    }

    public <T> T getInstance(Class<T> contractOrImpl, String classAnalyzer) {
        return (T)this.injectionManager.getInstance(contractOrImpl, classAnalyzer);
    }

    public <T> T getInstance(Type contractOrImpl) {
        return (T)this.injectionManager.getInstance(contractOrImpl);
    }

    public Object getInstance(ForeignDescriptor foreignDescriptor) {
        return this.injectionManager.getInstance(foreignDescriptor);
    }

    public void completeRegistration() {
        this.injectionManager.completeRegistration();
    }

    public void shutdown() {
        this.injectionManager.shutdown();
    }

    public boolean isShutdown() {
        return this.injectionManager.isShutdown();
    }

    public void register(Binding binding) {
        this.injectionManager.register(binding);
    }

    public void register(Iterable<Binding> descriptors) {
        this.injectionManager.register(descriptors);
    }

    public void register(Binder binder) {
        this.injectionManager.register(binder);
    }

    public void register(Object provider) throws IllegalArgumentException {
        this.injectionManager.register(provider);
    }

    public boolean isRegistrable(Class<?> clazz) {
        return this.injectionManager.isRegistrable(clazz);
    }

    public <T> T create(Class<T> createMe) {
        return (T)this.injectionManager.create(createMe);
    }

    public <T> T createAndInitialize(Class<T> createMe) {
        return (T)this.injectionManager.createAndInitialize(createMe);
    }

    public <T> List<ServiceHolder<T>> getAllServiceHolders(Class<T> contractOrImpl, Annotation ... qualifiers) {
        return this.injectionManager.getAllServiceHolders(contractOrImpl, qualifiers);
    }

    public ForeignDescriptor createForeignDescriptor(Binding binding) {
        return this.injectionManager.createForeignDescriptor(binding);
    }

    public <T> List<T> getAllInstances(Type contractOrImpl) {
        return this.injectionManager.getAllInstances(contractOrImpl);
    }

    public void inject(Object injectMe) {
        this.injectionManager.inject(injectMe);
    }

    public void inject(Object injectMe, String classAnalyzer) {
        this.injectionManager.inject(injectMe, classAnalyzer);
    }

    public void preDestroy(Object preDestroyMe) {
        this.injectionManager.preDestroy(preDestroyMe);
    }
}

