/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.jersey.internal;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServlet;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletException;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.jakartabridge.servlet.JakartaServletBridge;
import org.xwiki.rest.XWikiRestComponent;
import org.xwiki.rest.jersey.internal.RestletJacksonContextResolver;

@Component(roles={JerseyServletContainer.class})
@Singleton
public class JerseyServletContainer
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    @Inject
    @Named(value="context")
    private ComponentManager contextComponentManager;
    private final Map<ServletContainer, AtomicInteger> containers = new ConcurrentHashMap<ServletContainer, AtomicInteger>();
    private volatile ServletContainer container;

    public void init() throws jakarta.servlet.ServletException {
        AtomicInteger counter;
        ServletContainer newContainer = new ServletContainer(this.createResourceConfig());
        try {
            newContainer.init(JakartaServletBridge.toJavax((ServletConfig)this.getServletConfig()));
        }
        catch (ServletException e) {
            throw new jakarta.servlet.ServletException((Throwable)e);
        }
        ServletContainer previousContainer = this.container;
        this.containers.put(newContainer, new AtomicInteger());
        this.container = newContainer;
        if (previousContainer != null && ((counter = this.containers.get(previousContainer)) == null || counter.get() == 0)) {
            this.forgetAndDestroy(previousContainer);
        }
    }

    public void restart() throws jakarta.servlet.ServletException {
        if (this.container != null) {
            this.init();
        }
    }

    private ResourceConfig createResourceConfig() {
        ResourceConfig resourceConfig = new ResourceConfig();
        for (ComponentDescriptor descriptor : this.contextComponentManager.getComponentDescriptorList(XWikiRestComponent.class)) {
            resourceConfig.register(descriptor.getImplementation());
        }
        resourceConfig.register(RestletJacksonContextResolver.class);
        return resourceConfig;
    }

    public void service(ServletRequest req, ServletResponse res) throws jakarta.servlet.ServletException, IOException {
        ServletContainer requestContainer = this.container;
        AtomicInteger counter = this.containers.get(this.container);
        counter.incrementAndGet();
        try {
            this.container.service(JakartaServletBridge.toJavax((ServletRequest)req), JakartaServletBridge.toJavax((ServletResponse)res));
        }
        catch (ServletException e) {
            throw new jakarta.servlet.ServletException((Throwable)e);
        }
        finally {
            counter.decrementAndGet();
            if (this.container != requestContainer && counter.get() == 0) {
                this.forgetAndDestroy(requestContainer);
            }
        }
    }

    private void forgetAndDestroy(ServletContainer container) {
        if (this.containers.remove(container) != null) {
            container.destroy();
        }
    }

    public void destroy() {
        this.forgetAndDestroy(this.container);
    }

    public ServletContext getServletContext() {
        return JakartaServletBridge.toJakarta((javax.servlet.ServletContext)this.container.getServletContext());
    }
}

