/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.resource.temporary.internal;

import java.util.HashMap;
import java.util.LinkedList;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.resource.ResourceReferenceSerializer;
import org.xwiki.resource.temporary.TemporaryResourceReference;
import org.xwiki.url.ExtendedURL;
import org.xwiki.url.URLNormalizer;

@Component
@Singleton
public class ExtendedURLTemporaryResourceReferenceSerializer
implements ResourceReferenceSerializer<TemporaryResourceReference, ExtendedURL> {
    @Inject
    @Named(value="contextpath")
    private URLNormalizer<ExtendedURL> extendedURLNormalizer;
    @Inject
    @Named(value="url")
    private EntityReferenceSerializer<String> urlEntityReferenceSerializer;

    public ExtendedURL serialize(TemporaryResourceReference reference) {
        LinkedList<String> segments = new LinkedList<String>();
        segments.add("tmp");
        segments.add(reference.getModuleId());
        segments.add(this.serialize(reference.getOwningEntityReference()));
        segments.addAll(reference.getResourcePath());
        HashMap parameters = new HashMap(reference.getParameters());
        ExtendedURL result = new ExtendedURL(segments, parameters);
        return (ExtendedURL)this.extendedURLNormalizer.normalize(result);
    }

    private String serialize(EntityReference reference) {
        return reference.getType().toString().toLowerCase() + ":" + (String)this.urlEntityReferenceSerializer.serialize(reference, new Object[0]);
    }
}

