/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.resource.temporary.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.environment.Environment;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.resource.temporary.TemporaryResourceReference;
import org.xwiki.resource.temporary.TemporaryResourceStore;

@Component
@Singleton
public class DefaultTemporaryResourceStore
implements TemporaryResourceStore {
    @Inject
    private Environment environment;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File createTemporaryFile(TemporaryResourceReference reference, InputStream content) throws IOException {
        File temporaryFile = this.getTemporaryFile(reference);
        FileOutputStream fos = null;
        try {
            temporaryFile.getParentFile().mkdirs();
            fos = new FileOutputStream(temporaryFile);
            IOUtils.copy((InputStream)content, (OutputStream)fos);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fos);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)fos);
        return temporaryFile;
    }

    @Override
    public File getTemporaryFile(TemporaryResourceReference reference) throws IOException {
        ArrayList<String> segments = new ArrayList<String>();
        if (reference.getOwningEntityReference() != null) {
            for (EntityReference component : reference.getOwningEntityReference().getReversedReferenceChain()) {
                segments.add(component.getName());
            }
        }
        if (!reference.getParameters().isEmpty()) {
            segments.add(String.valueOf(reference.getParameters().hashCode()));
        }
        String path = StringUtils.join(this.encode(segments), (char)'/');
        String md5 = DigestUtils.md5Hex((String)path);
        File rootFolder = this.environment.getTemporaryDirectory();
        ArrayList<String> finalPathSegments = new ArrayList<String>();
        finalPathSegments.add("tmp");
        finalPathSegments.add(reference.getModuleId());
        finalPathSegments.add(String.valueOf(md5.charAt(0)));
        finalPathSegments.add(String.valueOf(md5.charAt(1)));
        finalPathSegments.add(String.valueOf(md5.substring(2)));
        File safeFolder = new File(rootFolder, StringUtils.join(finalPathSegments, (char)'/'));
        finalPathSegments.addAll(reference.getResourcePath());
        File temporaryFile = new File(rootFolder, StringUtils.join(finalPathSegments, (char)'/'));
        if (!temporaryFile.getAbsolutePath().startsWith(safeFolder.getAbsolutePath())) {
            throw new IOException(String.format("Resource path [%s] should be within [%s]", temporaryFile.getAbsolutePath(), safeFolder.getAbsolutePath()));
        }
        return temporaryFile;
    }

    private List<String> encode(List<String> path) {
        ArrayList<String> encodedPath = new ArrayList<String>(path.size());
        for (String segment : path) {
            try {
                encodedPath.add(URLEncoder.encode(segment, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        return encodedPath;
    }
}

