/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.resource.temporary;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.resource.ResourceType;
import org.xwiki.resource.entity.EntityResourceAction;
import org.xwiki.resource.entity.EntityResourceReference;

public class TemporaryResourceReference
extends EntityResourceReference {
    public static final ResourceType TYPE = new ResourceType("tmp");
    private final List<String> resourcePath;
    private final String moduleId;

    public TemporaryResourceReference(String moduleId, List<String> resourcePath, EntityReference owningEntityReference) {
        super(owningEntityReference, EntityResourceAction.fromString((String)""));
        this.setType(TYPE);
        this.moduleId = moduleId;
        this.resourcePath = Collections.unmodifiableList(new ArrayList<String>(resourcePath));
    }

    public TemporaryResourceReference(String moduleId, String resourceName, EntityReference owningEntityReference) {
        this(moduleId, Collections.singletonList(resourceName), owningEntityReference);
    }

    public TemporaryResourceReference(String moduleId, String resourceName) {
        this(moduleId, resourceName, null);
    }

    public EntityReference getOwningEntityReference() {
        return this.getEntityReference();
    }

    public String getResourceName() {
        return this.resourcePath.get(this.resourcePath.size() - 1);
    }

    public List<String> getResourcePath() {
        return this.resourcePath;
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public int hashCode() {
        return new HashCodeBuilder(23, 5).appendSuper(super.hashCode()).append((Object)this.getModuleId()).append((Object)this.getOwningEntityReference()).append(this.getResourcePath()).toHashCode();
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        TemporaryResourceReference reference = (TemporaryResourceReference)((Object)object);
        return new EqualsBuilder().append((Object)this.getModuleId(), (Object)reference.getModuleId()).append((Object)this.getOwningEntityReference(), (Object)reference.getOwningEntityReference()).append(this.getResourcePath(), reference.getResourcePath()).isEquals();
    }
}

