/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.util;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.icon.IconException;
import org.xwiki.icon.IconRenderer;
import org.xwiki.icon.IconSet;
import org.xwiki.icon.IconSetManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.FormatBlock;
import org.xwiki.rendering.block.RawBlock;
import org.xwiki.rendering.internal.util.DefaultIconProvider;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.syntax.Syntax;

@Component
@Singleton
public class XWikiIconProvider
extends DefaultIconProvider {
    @Inject
    private IconSetManager iconSetManager;
    @Inject
    private IconRenderer iconRenderer;

    public Block get(String iconName) {
        try {
            IconSet iconSet = this.getIconSet(iconName);
            String iconContent = this.iconRenderer.renderHTML(iconName, iconSet);
            FormatBlock formatBlock = new FormatBlock(List.of(new RawBlock(iconContent, Syntax.HTML_5_0)), Format.NONE);
            formatBlock.setParameter("class", "icon-block");
            return formatBlock;
        }
        catch (IconException e) {
            return super.get(iconName);
        }
    }

    private IconSet getIconSet(String iconName) throws IconException {
        IconSet iconSet = this.iconSetManager.getCurrentIconSet();
        if (iconSet == null || !iconSet.hasIcon(iconName)) {
            iconSet = this.iconSetManager.getDefaultIconSet();
        }
        return iconSet;
    }
}

