/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.resolver;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.rendering.listener.reference.ResourceReference;

@Component
@Named(value="relative")
@Singleton
public class RelativeResourceReferenceEntityReferenceResolver
implements EntityReferenceResolver<ResourceReference> {
    public static final ParameterizedType TYPE_RESOURCEREFERENCE = new DefaultParameterizedType(null, EntityReferenceResolver.class, new Type[]{ResourceReference.class});
    private static final String RELATIVE_HINT = "relative/%s";
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;

    public EntityReference resolve(ResourceReference resourceReference, EntityType type, Object ... parameters) {
        if (resourceReference == null) {
            return null;
        }
        if (((ComponentManager)this.componentManagerProvider.get()).hasComponent((Type)TYPE_RESOURCEREFERENCE, this.getRelativeHint(resourceReference))) {
            EntityReferenceResolver resolver;
            try {
                resolver = (EntityReferenceResolver)((ComponentManager)this.componentManagerProvider.get()).getInstance((Type)TYPE_RESOURCEREFERENCE, this.getRelativeHint(resourceReference));
            }
            catch (ComponentLookupException e) {
                throw new RuntimeException(String.format("Unknown error when trying to load resolver for reference [%s]", resourceReference), e);
            }
            return resolver.resolve((Object)resourceReference, type, parameters);
        }
        return null;
    }

    private String getRelativeHint(ResourceReference resourceReference) {
        return String.format(RELATIVE_HINT, resourceReference.getType().getScheme());
    }
}

