/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.ImageBlock;
import org.xwiki.rendering.block.LinkBlock;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.ClassBlockMatcher;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.macro.MacroRefactoring;
import org.xwiki.rendering.macro.MacroRefactoringException;

@Component(roles={LinkParser.class})
@Singleton
public class LinkParser {
    @Inject
    private EntityReferenceResolver<ResourceReference> entityReferenceResolver;
    @Inject
    private Provider<MacroRefactoring> defaultMacroRefactoringProvider;
    @Inject
    @Named(value="context")
    private ComponentManager componentManager;
    @Inject
    private Logger logger;

    public Set<ResourceReference> extractReferences(XDOM dom) {
        HashSet<ResourceReference> result = new HashSet<ResourceReference>();
        List linkBlocks = dom.getBlocks((BlockMatcher)new ClassBlockMatcher(LinkBlock.class), Block.Axes.DESCENDANT);
        List imageBlocks = dom.getBlocks((BlockMatcher)new ClassBlockMatcher(ImageBlock.class), Block.Axes.DESCENDANT);
        List macroBlocks = dom.getBlocks((BlockMatcher)new ClassBlockMatcher(MacroBlock.class), Block.Axes.DESCENDANT);
        for (LinkBlock linkBlock : linkBlocks) {
            result.add(linkBlock.getReference());
        }
        for (ImageBlock imageBlock : imageBlocks) {
            result.add(imageBlock.getReference());
        }
        for (MacroBlock macroBlock : macroBlocks) {
            MacroRefactoring macroRefactoring = (MacroRefactoring)this.defaultMacroRefactoringProvider.get();
            if (this.componentManager.hasComponent(MacroRefactoring.class, macroBlock.getId())) {
                try {
                    macroRefactoring = (MacroRefactoring)this.componentManager.getInstance(MacroRefactoring.class, macroBlock.getId());
                }
                catch (ComponentLookupException e) {
                    this.logger.warn("Error while loading macro refactoring component for macro [{}]: [{}]", (Object)macroBlock.getId(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                }
            }
            try {
                result.addAll(macroRefactoring.extractReferences(macroBlock));
            }
            catch (MacroRefactoringException e) {
                this.logger.warn("Error while extracting references from macro [{}]: [{}]", (Object)macroBlock.getId(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        return result;
    }

    public Set<EntityReference> getUniqueLinkedEntityReferences(XDOM dom, Map<EntityType, Set<ResourceType>> entityTypes, DocumentReference currentReference) {
        LinkedHashSet<EntityReference> result = new LinkedHashSet<EntityReference>();
        Set<ResourceReference> resourceReferences = this.extractReferences(dom);
        for (ResourceReference resourceReference : resourceReferences) {
            this.addReference(resourceReference, entityTypes, currentReference, result);
        }
        return result;
    }

    private void addReference(ResourceReference reference, Map<EntityType, Set<ResourceType>> entityTypes, DocumentReference currentReference, Set<EntityReference> references) {
        String referenceString = reference.getReference();
        ResourceType resourceType = reference.getType();
        Optional<EntityType> entityType = entityTypes.entrySet().stream().filter(e -> ((Set)e.getValue()).contains(resourceType)).map(Map.Entry::getKey).findFirst();
        if (entityType.isEmpty()) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)referenceString)) {
            return;
        }
        EntityReference linkEntityReference = this.entityReferenceResolver.resolve((Object)reference, entityType.get(), new Object[0]);
        if (!Objects.equals(linkEntityReference.extractReference(currentReference.getType()), currentReference)) {
            references.add(linkEntityReference);
        }
    }
}

