/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.ComponentMandatory;
import org.xwiki.rendering.block.RawBlock;
import org.xwiki.rendering.internal.transformation.macro.HTMLRawBlockFilter;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.syntax.SyntaxType;
import org.xwiki.rendering.transformation.macro.RawBlockFilterParameters;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@ComponentMandatory
@Singleton
@Named(value="html")
public class XWikiHTMLRawBlockFilter
extends HTMLRawBlockFilter {
    @Inject
    private ContextualAuthorizationManager authorizationManager;

    public RawBlock filter(RawBlock block, RawBlockFilterParameters parameters) throws MacroExecutionException {
        if (SyntaxType.HTML_FAMILY_TYPES.contains(block.getSyntax().getType()) && !this.authorizationManager.hasAccess(Right.SCRIPT)) {
            parameters.setRestricted(true);
        }
        return super.filter(block, parameters);
    }
}

