/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.platform.security.requiredrights.MacroRequiredRight;
import org.xwiki.platform.security.requiredrights.MacroRequiredRightReporter;
import org.xwiki.platform.security.requiredrights.MacroRequiredRightsAnalyzer;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.syntax.SyntaxRegistry;
import org.xwiki.rendering.syntax.SyntaxType;

@Component
@Singleton
@Named(value="raw")
public class RawMacroRequiredRightsAnalyzer
implements MacroRequiredRightsAnalyzer {
    @Inject
    private SyntaxRegistry syntaxRegistry;

    public void analyze(MacroBlock macroBlock, MacroRequiredRightReporter reporter) {
        boolean isHTML = macroBlock.getParameters().entrySet().stream().filter(entry -> "syntax".equalsIgnoreCase((String)entry.getKey())).anyMatch(entry -> this.isHTMLSyntax((String)entry.getValue()));
        if (isHTML) {
            reporter.report(macroBlock, List.of(MacroRequiredRight.SCRIPT), "rendering.macro.rawMacroRequiredRights", new Object[0]);
        }
    }

    private boolean isHTMLSyntax(String syntaxValue) {
        try {
            SyntaxType syntax = this.syntaxRegistry.resolveSyntax(syntaxValue).getType();
            return SyntaxType.HTML_FAMILY_TYPES.contains(syntax);
        }
        catch (ParseException e) {
            return false;
        }
    }
}

