/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.w3c.dom.Document;
import org.xwiki.component.annotation.Component;
import org.xwiki.platform.security.requiredrights.MacroRequiredRight;
import org.xwiki.platform.security.requiredrights.MacroRequiredRightReporter;
import org.xwiki.platform.security.requiredrights.MacroRequiredRightsAnalyzer;
import org.xwiki.properties.ConverterManager;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.xml.html.HTMLCleaner;
import org.xwiki.xml.html.HTMLCleanerConfiguration;
import org.xwiki.xml.html.filter.HTMLFilter;

@Component
@Singleton
@Named(value="html")
public class HTMLMacroRequiredRightsAnalyzer
implements MacroRequiredRightsAnalyzer {
    private static final String TRANSLATION_PREFIX = "rendering.macro.htmlRequiredRights.";
    @Inject
    private HTMLCleaner htmlCleaner;
    @Inject
    private ConverterManager converter;
    @Inject
    @Named(value="restrictedFilterDetector")
    private HTMLFilter restrictedFilterDetector;

    public void analyze(MacroBlock macroBlock, MacroRequiredRightReporter reporter) {
        boolean wiki = this.getBooleanParameterValues(macroBlock, "wiki").anyMatch(Boolean.TRUE::equals);
        boolean clean = this.getBooleanParameterValues(macroBlock, "clean").noneMatch(Boolean.FALSE::equals);
        if (wiki) {
            reporter.analyzeContent(macroBlock, macroBlock.getContent());
        }
        if (!clean) {
            reporter.report(macroBlock, List.of(MacroRequiredRight.SCRIPT), "rendering.macro.htmlRequiredRights.noClean", new Object[0]);
        } else if (wiki) {
            reporter.report(macroBlock, List.of(MacroRequiredRight.MAYBE_SCRIPT), "rendering.macro.htmlRequiredRights.wikiContent", new Object[0]);
        } else {
            HTMLCleanerConfiguration cleanerConfiguration = this.htmlCleaner.getDefaultConfiguration();
            HashMap<String, String> parameters = new HashMap<String, String>(cleanerConfiguration.getParameters());
            parameters.put("htmlVersion", "5");
            cleanerConfiguration.setParameters(parameters);
            ArrayList<HTMLFilter> filters = new ArrayList<HTMLFilter>(cleanerConfiguration.getFilters());
            filters.add(this.restrictedFilterDetector);
            cleanerConfiguration.setFilters(filters);
            Document document = this.htmlCleaner.clean((Reader)new StringReader(macroBlock.getContent()), cleanerConfiguration);
            if (Boolean.parseBoolean(document.getDocumentElement().getAttribute("restrictedFiltering"))) {
                reporter.report(macroBlock, List.of(MacroRequiredRight.SCRIPT), "rendering.macro.htmlRequiredRights.dangerousContent", new Object[0]);
            }
        }
    }

    private Stream<Boolean> getBooleanParameterValues(MacroBlock macroBlock, String parameterName) {
        return macroBlock.getParameters().entrySet().stream().filter(entry -> parameterName.equalsIgnoreCase((String)entry.getKey())).map(entry -> (Boolean)this.converter.convert(Boolean.class, entry.getValue()));
    }
}

