/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.platform.security.requiredrights.MacroRequiredRight;
import org.xwiki.platform.security.requiredrights.MacroRequiredRightReporter;
import org.xwiki.platform.security.requiredrights.MacroRequiredRightsAnalyzer;
import org.xwiki.properties.ConverterManager;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.macro.source.MacroContentSourceReference;
import org.xwiki.rendering.syntax.Syntax;

@Component
@Singleton
@Named(value="content")
public class ContentMacroRequiredRightsAnalyzer
implements MacroRequiredRightsAnalyzer {
    @Inject
    private ConverterManager converterManager;

    public void analyze(MacroBlock macroBlock, MacroRequiredRightReporter reporter) {
        List<Syntax> contentSyntaxes = this.getParameterValues(macroBlock, Syntax.class, "syntax");
        List<MacroContentSourceReference> sources = this.getParameterValues(macroBlock, MacroContentSourceReference.class, "source");
        if (!sources.isEmpty()) {
            for (MacroContentSourceReference source : sources) {
                if ("script".equals(source.getType())) {
                    reporter.report(macroBlock, List.of(MacroRequiredRight.SCRIPT, MacroRequiredRight.MAYBE_PROGRAM), "rendering.macro.content.requiredRights.scriptSource", new Object[0]);
                    continue;
                }
                if (!"string".equals(source.getType())) continue;
                ContentMacroRequiredRightsAnalyzer.analyzeContentWithSyntaxes(macroBlock, reporter, contentSyntaxes, source.getReference());
            }
        } else {
            ContentMacroRequiredRightsAnalyzer.analyzeContentWithSyntaxes(macroBlock, reporter, contentSyntaxes, macroBlock.getContent());
        }
    }

    private static void analyzeContentWithSyntaxes(MacroBlock macroBlock, MacroRequiredRightReporter reporter, List<Syntax> contentSyntaxes, String content) {
        if (contentSyntaxes.isEmpty()) {
            reporter.analyzeContent(macroBlock, content);
        } else {
            contentSyntaxes.forEach(syntax -> reporter.analyzeContent(macroBlock, content, syntax));
        }
    }

    private <T> List<T> getParameterValues(MacroBlock macroBlock, Class<T> tClass, String parameterName) {
        return macroBlock.getParameters().entrySet().stream().filter(entry -> parameterName.equalsIgnoreCase((String)entry.getKey())).map(entry -> {
            try {
                return this.converterManager.convert((Type)tClass, entry.getValue());
            }
            catch (Exception e) {
                return null;
            }
        }).filter(Objects::nonNull).toList();
    }
}

