/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.context;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.rendering.async.internal.AbstractExecutedContentMacro;
import org.xwiki.rendering.async.internal.block.BlockAsyncRendererConfiguration;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.MetaDataBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.internal.macro.context.ContextMacroDocument;
import org.xwiki.rendering.listener.MetaData;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.MacroPreparationException;
import org.xwiki.rendering.macro.context.ContextMacroParameters;
import org.xwiki.rendering.macro.context.TransformationContextMode;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.macro.source.MacroContentWikiSource;
import org.xwiki.rendering.macro.source.MacroContentWikiSourceFactory;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.rendering.transformation.TransformationContext;
import org.xwiki.rendering.transformation.TransformationManager;

@Component
@Named(value="context")
@Singleton
public class ContextMacro
extends AbstractExecutedContentMacro<ContextMacroParameters> {
    private static final String DESCRIPTION = "Executes content in the context of the passed document";
    private static final String CONTENT_DESCRIPTION = "The content to execute";
    @Inject
    private TransformationManager transformationManager;
    @Inject
    private MacroContentWikiSourceFactory contentFactory;
    @Inject
    private ContextMacroDocument documentHandler;

    public ContextMacro() {
        super("Context", DESCRIPTION, (ContentDescriptor)new DefaultContentDescriptor(CONTENT_DESCRIPTION, false, Block.LIST_BLOCK_TYPE), ContextMacroParameters.class);
        this.setDefaultCategories(Set.of("Development"));
    }

    public List<Block> execute(ContextMacroParameters parameters, String macroContent, MacroTransformationContext context) throws MacroExecutionException {
        XDOM xdom;
        MetaData metadata;
        if (parameters.getDocument() != null) {
            metadata = new MetaData();
            metadata.addMetaData("source", (Object)parameters.getDocument());
            metadata.addMetaData("base", (Object)parameters.getDocument());
        } else {
            metadata = null;
        }
        String content = macroContent;
        Syntax syntax = null;
        if (parameters.getSource() != null) {
            MacroContentWikiSource wikiSource = this.contentFactory.getContent(parameters.getSource(), context);
            syntax = wikiSource.getSyntax();
            content = wikiSource.getContent();
        }
        if ((xdom = this.parser.parse(content, syntax, context, false, metadata, context.isInline())).getChildren().isEmpty()) {
            return Collections.emptyList();
        }
        List blocks = parameters.isRestricted() || parameters.getTransformationContext() == TransformationContextMode.DOCUMENT || parameters.getTransformationContext() == TransformationContextMode.TRANSFORMATIONS ? this.executeContext(xdom, parameters, context) : xdom.getChildren();
        return Arrays.asList(new MetaDataBlock(blocks, xdom.getMetaData()));
    }

    private List<Block> executeContext(XDOM xdom, ContextMacroParameters parameters, MacroTransformationContext context) throws MacroExecutionException {
        DocumentReference referencedDocReference = this.documentHandler.getDocumentReference(parameters, context);
        BlockAsyncRendererConfiguration configuration = this.createBlockAsyncRendererConfiguration(null, (Block)xdom, context);
        configuration.setAsyncAllowed(false);
        configuration.setCacheAllowed(false);
        if (parameters.isRestricted()) {
            configuration.setResricted(true);
        }
        HashMap backupObjects = null;
        try {
            if (referencedDocReference != null) {
                backupObjects = new HashMap();
                this.documentAccessBridge.pushDocumentInContext(backupObjects, referencedDocReference);
                DocumentModelBridge referencedDoc = this.documentAccessBridge.getTranslatedDocumentInstance(referencedDocReference);
                XDOM referencedXDOM = referencedDoc.getPreparedXDOM();
                if (parameters.getTransformationContext() == TransformationContextMode.TRANSFORMATIONS) {
                    TransformationContext referencedTxContext = new TransformationContext(referencedXDOM, referencedDoc.getSyntax(), referencedDoc.isRestricted());
                    this.transformationManager.performTransformations((Block)referencedXDOM, referencedTxContext);
                }
                configuration.setXDOM(referencedXDOM);
            }
            Block result = this.executor.execute(configuration);
            List list = result.getChildren();
            return list;
        }
        catch (Exception e) {
            throw new MacroExecutionException("Failed start the execution of the macro", (Throwable)e);
        }
        finally {
            if (backupObjects != null) {
                this.documentAccessBridge.popDocumentFromContext(backupObjects);
            }
        }
    }

    public void prepare(MacroBlock macroBlock) throws MacroPreparationException {
        if (macroBlock.getParameter("source") == null) {
            this.parser.prepareContentWiki(macroBlock);
        }
    }
}

