/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.container;

import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.macro.MacroContentParser;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.MacroPreparationException;
import org.xwiki.rendering.macro.container.AbstractContainerMacro;
import org.xwiki.rendering.macro.container.ContainerMacroParameters;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.transformation.MacroTransformationContext;

@Component
@Named(value="container")
@Singleton
public class ContainerMacro
extends AbstractContainerMacro<ContainerMacroParameters> {
    public static final String MACRO_NAME = "container";
    private static final String DESCRIPTION = "A macro to enclose multiple groups and add decoration, such as layout.";
    private static final String CONTENT_DESCRIPTION = "The content to enclose in this container (wiki syntax). For the \"columns\" layout, a group should be added for each column.";
    @Inject
    private MacroContentParser contentParser;

    public ContainerMacro() {
        super("Container", DESCRIPTION, (ContentDescriptor)new DefaultContentDescriptor(CONTENT_DESCRIPTION, false, Block.LIST_BLOCK_TYPE), ContainerMacroParameters.class);
        this.setDefaultCategories(Set.of("Layout"));
    }

    @Override
    protected List<Block> getContent(ContainerMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        return this.contentParser.parse(content, context, false, false).getChildren();
    }

    public void prepare(MacroBlock macroBlock) throws MacroPreparationException {
        this.contentParser.prepareContentWiki(macroBlock);
    }

    public int getPriority() {
        return 750;
    }
}

